/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.resource;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.OptionalInt;
import net.oneandone.concierge.api.Element;
import net.oneandone.concierge.api.filter.AddressFilter;
import net.oneandone.concierge.api.filter.Filters;
import net.oneandone.concierge.api.filter.PageFilter;

public class ResourceIdentifier {
    private final String[] uri;
    private final int startIndex;
    private final Multimap<String, String> parameters;

    public static ResourceIdentifier parse(String uri) {
        return new ResourceIdentifier(uri, (Multimap<String, String>)ImmutableMultimap.of());
    }

    public static ResourceIdentifier parse(String uri, Multimap<String, String> parameters) {
        return new ResourceIdentifier(uri, parameters);
    }

    private ResourceIdentifier(String uri, Multimap<String, String> parameters) {
        Preconditions.checkNotNull((Object)uri, (Object)"the URI may not be null");
        Preconditions.checkArgument((!uri.startsWith("/") ? 1 : 0) != 0, (Object)"the URI may not start with slash");
        this.uri = uri.isEmpty() ? new String[0] : uri.split("/");
        this.parameters = ImmutableMultimap.copyOf(parameters);
        this.startIndex = 0;
    }

    private ResourceIdentifier(String[] uri, Multimap<String, String> parameters, int startIndex) {
        this.uri = uri;
        this.parameters = parameters;
        this.startIndex = startIndex;
    }

    public String[] get() {
        return Arrays.copyOf(this.uri, this.uri.length);
    }

    public boolean empty() {
        return this.uri.length == 0;
    }

    public String[] hierarchy() {
        String[] resolverHierarchy = new String[this.startIndex / 2 + 1];
        for (int i = 0; i <= this.startIndex; i += 2) {
            resolverHierarchy[i / 2] = this.uri[i];
        }
        return resolverHierarchy;
    }

    public String[] extendedHierarchy(String extension) {
        String[] resolverHierarchy = this.hierarchy();
        String[] extendedResolverHierarchy = Arrays.copyOfRange(resolverHierarchy, 0, resolverHierarchy.length + 1);
        extendedResolverHierarchy[resolverHierarchy.length] = extension;
        return extendedResolverHierarchy;
    }

    public String[] completeHierarchy() {
        String[] resolverHierarchy = this.uri.length % 2 == 0 ? new String[this.uri.length / 2] : new String[this.uri.length / 2 + 1];
        for (int i = 0; i < this.uri.length; i += 2) {
            resolverHierarchy[i / 2] = this.uri[i];
        }
        return resolverHierarchy;
    }

    public boolean hasNextScope() {
        return this.startIndex + 2 < this.uri.length;
    }

    public ResourceIdentifier next() {
        if (this.hasNextScope()) {
            return new ResourceIdentifier(this.uri, this.parameters, this.startIndex + 2);
        }
        throw new IndexOutOfBoundsException("next resource identifier is not available");
    }

    public boolean hasElementIdentifier() {
        return this.startIndex + 1 <= this.uri.length - 1;
    }

    public String groupIdentifier() {
        return this.uri[this.startIndex];
    }

    private String elementIdentifier() {
        if (this.hasElementIdentifier()) {
            return this.uri[this.startIndex + 1];
        }
        throw new IndexOutOfBoundsException("resource identifier has no element identifier");
    }

    public ResourceIdentifier extend(String extension) {
        if (this.hasElementIdentifier()) {
            String[] newUri = Arrays.copyOfRange(this.uri, 0, this.startIndex + 3);
            newUri[this.startIndex + 2] = extension;
            return new ResourceIdentifier(newUri, this.parameters, this.startIndex);
        }
        throw new IllegalArgumentException("resource identifier is not extensible");
    }

    public ResourceIdentifier extend(Element element) {
        if (!this.hasElementIdentifier()) {
            String[] newUri = Arrays.copyOfRange(this.uri, 0, this.startIndex + 2);
            newUri[this.startIndex + 1] = element.address();
            return new ResourceIdentifier(newUri, this.parameters, this.startIndex);
        }
        throw new IllegalArgumentException("current resource identifier " + Arrays.toString(this.uri) + " is not expendable by an element");
    }

    public Collection<String> extensions() {
        return this.parameters.get((Object)"show");
    }

    public Filters filters() {
        Filters.Builder builder = Filters.Builder.initialize();
        if (this.hasElementIdentifier()) {
            builder.add(new AddressFilter(this.elementIdentifier()));
        }
        if (!this.hasNextScope() && (this.parameters.containsKey((Object)"page") || this.parameters.containsKey((Object)"per_page"))) {
            Collection pageValues = this.parameters.get((Object)"page");
            int page = pageValues.isEmpty() ? 1 : Integer.parseInt((String)pageValues.stream().findFirst().get());
            Collection perPageValues = this.parameters.get((Object)"per_page");
            OptionalInt perPage = perPageValues.isEmpty() ? OptionalInt.empty() : OptionalInt.of(Integer.parseInt((String)perPageValues.stream().findFirst().get()));
            builder.add(new PageFilter(page, perPage));
        }
        return builder.build();
    }
}

