/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.concierge.resource.response;

public class ApiResourcePaging {
    private final String group;
    private final int page;
    private final int perPage;
    private final int total;

    public String getAcceptRanges() {
        return this.group;
    }

    public String getContentRange() {
        int min = this.page * this.perPage - this.perPage;
        int max = Math.min(this.page * this.perPage, this.total) - 1;
        return this.getAcceptRanges() + " " + min + "-" + max + "/" + this.total;
    }

    ApiResourcePaging(String group, int page, int perPage, int total) {
        this.group = group;
        this.page = page;
        this.perPage = perPage;
        this.total = total;
    }

    public static ApiResourcePagingBuilder builder() {
        return new ApiResourcePagingBuilder();
    }

    public static class ApiResourcePagingBuilder {
        private String group;
        private int page;
        private int perPage;
        private int total;

        ApiResourcePagingBuilder() {
        }

        public ApiResourcePagingBuilder group(String group) {
            this.group = group;
            return this;
        }

        public ApiResourcePagingBuilder page(int page) {
            this.page = page;
            return this;
        }

        public ApiResourcePagingBuilder perPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        public ApiResourcePagingBuilder total(int total) {
            this.total = total;
            return this;
        }

        public ApiResourcePaging build() {
            return new ApiResourcePaging(this.group, this.page, this.perPage, this.total);
        }

        public String toString() {
            return "ApiResourcePaging.ApiResourcePagingBuilder(group=" + this.group + ", page=" + this.page + ", perPage=" + this.perPage + ", total=" + this.total + ")";
        }
    }
}

