/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit;

import com.oneandone.ejbcdiunit.CreationalContexts;
import com.oneandone.ejbcdiunit.internal.EjbExtensionExtended;
import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AsynchronousManager {
    private static final int TIME_TO_WAIT_AFTER_HANDLING = 200;
    private static final int TIME_TO_WAIT_FOR_INTERRUPT = 200;
    private static final int TIME_TO_STOP_LOOPING_ONCE = 200;
    @Inject
    SimulatedTransactionManager transactionManager;
    @Inject
    EjbExtensionExtended ejbExtensionExtended;
    @Inject
    BeanManager bm;
    private Logger logger = LoggerFactory.getLogger((String)"AsynchronousManager");
    private CreationalContexts creationalContexts = null;
    private ArrayList<AsynchronousRunnable> runnables = new ArrayList();
    private boolean enqueAsynchronousCalls = false;
    private Thread asyncHandler = null;

    public boolean doesEnqueAsynchronousCalls() {
        return this.enqueAsynchronousCalls;
    }

    public void setEnqueAsynchronousCalls(boolean enqueAsynchronousCalls1) {
        this.enqueAsynchronousCalls = enqueAsynchronousCalls1;
    }

    String addTimerMethods() {
        if (this.creationalContexts != null) {
            throw new RuntimeException("Second call of addTimerMethods on AsynchronousManager");
        }
        StringBuilder sb = new StringBuilder();
        List<Class<?>> timerClasses = this.ejbExtensionExtended.getTimerClasses();
        this.creationalContexts = new CreationalContexts(this.bm);
        for (Class<?> timerClass : timerClasses) {
            Set beans = this.bm.getBeans(timerClass, new Annotation[0]);
            for (Bean b : beans) {
                Method[] methods;
                Class c = b.getBeanClass();
                for (final Method m : methods = c.getMethods()) {
                    if (m.getAnnotation(Schedules.class) == null && m.getAnnotation(Schedule.class) == null && m.getAnnotation(Timeout.class) == null) continue;
                    if (m.getParameterTypes().length > 0) {
                        this.logger.error("Can not handle automatically Bean with class {} and TimeoutMethod {}", (Object)c.getCanonicalName(), (Object)m.getName());
                        continue;
                    }
                    final Object o = this.creationalContexts.create(b, (Class<? extends Annotation>)Dependent.class);
                    this.addMultipleHandler(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                m.invoke(o, new Object[0]);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(c.getCanonicalName());
                    sb.append("#");
                    sb.append(m.getName());
                    this.logger.info("Installed Timer for Class: {}, Method: {} ", (Object)c.getSimpleName(), (Object)m.getName());
                }
            }
        }
        return sb.toString();
    }

    public void startThread() {
        if (this.asyncHandler == null) {
            this.initThread();
        }
    }

    private void initThread() {
        this.asyncHandler = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    long time = System.currentTimeMillis();
                    try {
                        int done = AsynchronousManager.this.once();
                        if (done > 0) {
                            AsynchronousManager.this.logger.info("AsynchronousManager handled {} runners", (Object)done);
                        }
                        while (AsynchronousManager.this.thereAreOnces() && System.currentTimeMillis() - time < 200L) {
                            done = AsynchronousManager.this.once();
                            if (done <= 0) continue;
                            AsynchronousManager.this.logger.info("AsynchronousManager handled {} runners", (Object)done);
                        }
                    }
                    catch (InterruptThreadException e) {
                        AsynchronousManager.this.logger.info("Asynchronous Manager Thread received end signal");
                        break;
                    }
                    catch (Throwable thw) {
                        AsynchronousManager.this.logger.error("Asynchronous Manager intercepted: ", thw);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                AsynchronousManager.this.logger.info("AsynchronousManager Thread after loop.");
            }
        });
        this.asyncHandler.setDaemon(true);
        this.asyncHandler.start();
        this.logger.info("Thread started");
    }

    public void stopThread() {
        if (this.asyncHandler != null) {
            this.logger.info("start stopping thread");
            this.addOneTimeHandler(new Runnable(){

                @Override
                public void run() {
                    throw new InterruptThreadException();
                }
            });
            while (this.asyncHandler.isAlive()) {
                try {
                    Thread.sleep(200L);
                    this.logger.info("waiting for thread to stop");
                }
                catch (InterruptedException e) {
                    this.logger.error("Thread interrupted");
                }
            }
            this.logger.info("ready stopping thread");
            this.asyncHandler = null;
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.stopThread();
        if (this.creationalContexts != null) {
            this.creationalContexts.closeIt();
        }
        if (!this.runnables.isEmpty()) {
            this.logger.error("There are {} runnables for left for this Test. Possibly no Consumer created or AsynchronousManager not polled.", (Object)this.runnables.size());
            throw new RuntimeException("There are runnables for left for this Test. Possibly no Consumer created or AsynchronousManager not polled");
        }
    }

    public synchronized void addOneTimeHandler(final Runnable runnable) {
        this.runnables.add(new AsynchronousOnetimeRunnable(){

            @Override
            public void run() {
                try {
                    AsynchronousManager.this.transactionManager.push(TransactionAttributeType.NOT_SUPPORTED);
                    runnable.run();
                }
                catch (InterruptThreadException e) {
                    AsynchronousManager.this.logger.info("Asynchronous Manager Thread received end signal");
                    throw e;
                }
                catch (Throwable thw) {
                    AsynchronousManager.this.logger.error("Error during OneTimeHandler", thw);
                }
                finally {
                    try {
                        AsynchronousManager.this.transactionManager.pop();
                    }
                    catch (Exception e) {
                        AsynchronousManager.this.logger.error("AsynchronousManager catched: {} during TransactionManager#pop.", (Object)e.getMessage(), (Object)" no further handling");
                    }
                }
            }
        });
    }

    public synchronized void addMultipleHandler(final Runnable runnable) {
        this.runnables.add(new AsynchronousMultipleRunnable(){

            @Override
            public void run() {
                try {
                    AsynchronousManager.this.transactionManager.push(TransactionAttributeType.NOT_SUPPORTED);
                    runnable.run();
                }
                catch (InterruptThreadException e) {
                    AsynchronousManager.this.logger.info("Asynchronous Manager Thread received end signal");
                    throw e;
                }
                catch (Throwable thw) {
                    AsynchronousManager.this.logger.error("Error during MultipleHandler", thw);
                }
                finally {
                    try {
                        AsynchronousManager.this.transactionManager.pop();
                    }
                    catch (Exception e) {
                        AsynchronousManager.this.logger.error("AsynchronousManager catched: {} during TransactionManager#pop.", (Object)e.getMessage(), (Object)" no further handling");
                    }
                }
            }
        });
    }

    private synchronized List<AsynchronousRunnable> cloneRunnables() {
        ArrayList<AsynchronousRunnable> result = new ArrayList<AsynchronousRunnable>(this.runnables.size());
        result.addAll(this.runnables);
        if (result.size() > 1) {
            this.logger.info("Encountered more than one possibility to run asynchronous, different sequences might produce different results.");
        }
        return result;
    }

    private synchronized void remove(AsynchronousRunnable runner) {
        this.runnables.remove(runner);
    }

    public int once() {
        int runnersCount = 0;
        List<AsynchronousRunnable> runners = this.cloneRunnables();
        for (AsynchronousRunnable runner : runners) {
            runner.run();
            ++runnersCount;
            if (!runner.oneShotOnly()) continue;
            this.remove(runner);
        }
        return runnersCount;
    }

    public int oneShotOnly() {
        int runnersCount = 0;
        List<AsynchronousRunnable> runners = this.cloneRunnables();
        for (AsynchronousRunnable runner : runners) {
            if (!runner.oneShotOnly()) continue;
            runner.run();
            ++runnersCount;
            this.remove(runner);
        }
        return runnersCount;
    }

    public void until(AsynchronousCallEndCondition predicate) {
        do {
            List<AsynchronousRunnable> runners;
            if ((runners = this.cloneRunnables()).isEmpty()) {
                return;
            }
            for (AsynchronousRunnable runner : runners) {
                runner.run();
                if (!runner.oneShotOnly()) continue;
                this.remove(runner);
            }
        } while (!predicate.stopCalling());
    }

    public void untilNothingLeft() {
        this.until(new AsynchronousCallEndCondition(){

            @Override
            public boolean stopCalling() {
                for (AsynchronousRunnable ar : AsynchronousManager.this.runnables) {
                    if (!ar.oneShotOnly()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public boolean thereAreOnces() {
        for (AsynchronousRunnable r : this.runnables) {
            if (!(r instanceof AsynchronousOnetimeRunnable)) continue;
            return true;
        }
        return false;
    }

    private static abstract class AsynchronousMultipleRunnable
    implements AsynchronousRunnable {
        private AsynchronousMultipleRunnable() {
        }

        @Override
        public boolean oneShotOnly() {
            return false;
        }
    }

    private static abstract class AsynchronousOnetimeRunnable
    implements AsynchronousRunnable {
        private AsynchronousOnetimeRunnable() {
        }

        @Override
        public boolean oneShotOnly() {
            return true;
        }
    }

    private static class InterruptThreadException
    extends RuntimeException {
        private static final long serialVersionUID = -1786916994010029037L;

        private InterruptThreadException() {
        }
    }

    private static interface AsynchronousRunnable {
        public void run();

        public boolean oneShotOnly();
    }

    public static interface AsynchronousCallEndCondition {
        public boolean stopCalling();
    }
}

