/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreationalContexts<T>
implements AutoCloseable {
    private final BeanManager bm;
    private List<CreationalContext<T>> creationalContexts = new ArrayList<CreationalContext<T>>();
    private Logger logger = null;

    CreationalContexts() throws NamingException {
        try (InitialContext initialContext = null;){
            initialContext = new InitialContext();
            this.bm = (BeanManager)initialContext.lookup("java:comp/BeanManager");
        }
    }

    public CreationalContexts(BeanManager bm) {
        this.bm = bm;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)"CreationalContexts");
        }
        return this.logger;
    }

    public Object create(Class<T> clazz, Class<? extends Annotation> scope) {
        Bean bean = this.bm.resolve(this.bm.getBeans(clazz, new Annotation[0]));
        if (bean != null) {
            Object result = this.create((Contextual<T>)bean, scope);
            if (result == null) {
                throw new RuntimeException("Could not create Bean to be initialized of Class: " + clazz);
            }
            return result;
        }
        throw new RuntimeException("Could not resolve Bean to be initialized of Class: " + clazz);
    }

    public Object create(Contextual<T> b, Class<? extends Annotation> scope) {
        try {
            CreationalContext cb = this.bm.createCreationalContext(b);
            Context context = this.bm.getContext(scope);
            Object o = context.get(b, cb);
            this.creationalContexts.add(cb);
            return o;
        }
        catch (Throwable thw) {
            this.getLogger().error("Exception during create of Bean {}", b);
            this.getLogger().error("Exception: ", thw);
            throw new RuntimeException(thw);
        }
    }

    public void closeIt() {
        for (CreationalContext<T> cc : this.creationalContexts) {
            cc.release();
        }
    }

    @Override
    public void close() throws Exception {
        this.closeIt();
    }
}

