/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit;

import com.oneandone.ejbcdiunit.AsynchronousManager;
import com.oneandone.ejbcdiunit.CreationalContexts;
import com.oneandone.ejbcdiunit.internal.EjbExtensionExtended;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class EjbUnitBeanInitializerClass {
    @Inject
    EjbExtensionExtended ejbExtensionExtended;
    @Inject
    BeanManager bm;
    @Inject
    AsynchronousManager asynchronousManager;
    Logger logger = null;
    private CreationalContexts creationalContexts;

    Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)"LateInitializerClass");
        }
        return this.logger;
    }

    @PostConstruct
    public void init() {
        List<Class<?>> startups = this.ejbExtensionExtended.getStartupSingletons();
        if (!startups.isEmpty()) {
            try {
                this.creationalContexts = new CreationalContexts();
                for (Class<?> clazz : startups) {
                    this.creationalContexts.create(clazz, ApplicationScoped.class);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        this.asynchronousManager.addTimerMethods();
    }

    @PreDestroy
    private void preDestroy() {
        if (this.creationalContexts != null) {
            try {
                this.creationalContexts.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

