/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit;

import com.oneandone.ejbcdiunit.CdiTestConfig;
import com.oneandone.ejbcdiunit.CreationalContexts;
import com.oneandone.ejbcdiunit.EjbUnitBeanInitializerClass;
import com.oneandone.ejbcdiunit.EjbUnitRunner;
import com.oneandone.ejbcdiunit.EjbUnitTransactionServices;
import com.oneandone.ejbcdiunit.SupportEjbExtended;
import com.oneandone.ejbcdiunit.cdiunit.Weld11TestUrlDeployment;
import com.oneandone.ejbcdiunit.cdiunit.WeldTestConfig;
import com.oneandone.ejbcdiunit.cdiunit.WeldTestUrlDeployment;
import com.oneandone.ejbcdiunit.internal.EjbInformationBean;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.reflection.Formats;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbUnitRule
implements TestRule {
    private static Logger logger = LoggerFactory.getLogger(EjbUnitRunner.class);
    private final Object instance;
    private CdiTestConfig cdiTestConfig;
    private Method method;

    public EjbUnitRule(Object instance, CdiTestConfig cdiTestConfig) {
        this.instance = instance;
        this.cdiTestConfig = cdiTestConfig;
    }

    public EjbUnitRule(Object instance) {
        this(instance, null);
    }

    public Statement apply(Statement base, Description description) {
        try {
            this.method = description.getTestClass().getMethod(description.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Deployment result = new Deployment(this.instance, base, this.method, this.cdiTestConfig);
        if (result.startupException != null && !this.method.getAnnotation(Test.class).expected().equals(result.startupException.getClass())) {
            throw new RuntimeException(result.startupException);
        }
        return result;
    }

    public class Deployment
    extends Statement {
        private static final String ABSENT_CODE_PREFIX = "Absent Code attribute in method that is not native or abstract in class file ";
        private final Statement next;
        protected Weld weld;
        protected WeldContainer container;
        protected Throwable startupException;
        private Class<?> clazz;
        private Object testInstance;

        public Deployment(Object instance, Statement next, Method method, CdiTestConfig cdiTestConfig) {
            this.clazz = instance.getClass();
            this.testInstance = instance;
            this.next = next;
            try {
                String version = Formats.version((Package)WeldBootstrap.class.getPackage());
                if ("2.2.8 (Final)".equals(version) || "2.2.7 (Final)".equals(version)) {
                    this.startupException = new Exception("Weld 2.2.8 and 2.2.7 are not supported. Suggest upgrading to 2.2.9");
                }
                final WeldTestConfig weldTestConfig = ((WeldTestConfig)new WeldTestConfig(this.clazz, method, cdiTestConfig).addClass((Class)SupportEjbExtended.class)).addServiceConfig(new CdiTestConfig.ServiceConfig<EjbUnitTransactionServices>(TransactionServices.class, new EjbUnitTransactionServices()));
                EjbUnitRule.this.cdiTestConfig = weldTestConfig;
                this.weld = new Weld(){

                    protected org.jboss.weld.bootstrap.spi.Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
                        try {
                            return new Weld11TestUrlDeployment(resourceLoader, (Bootstrap)bootstrap, weldTestConfig);
                        }
                        catch (IOException e) {
                            Deployment.this.startupException = e;
                            throw new RuntimeException(e);
                        }
                    }

                    protected org.jboss.weld.bootstrap.spi.Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
                        try {
                            return new WeldTestUrlDeployment(resourceLoader, bootstrap, weldTestConfig);
                        }
                        catch (IOException e) {
                            Deployment.this.startupException = e;
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (ClassFormatError e) {
                this.startupException = this.parseClassFormatError(e);
            }
            catch (Throwable e) {
                this.startupException = new Exception("Unable to start weld", e);
            }
        }

        private ClassFormatError parseClassFormatError(ClassFormatError e) {
            if (e.getMessage().startsWith(ABSENT_CODE_PREFIX)) {
                String offendingClass = e.getMessage().substring(ABSENT_CODE_PREFIX.length());
                URL url = EjbUnitRule.class.getClassLoader().getResource(offendingClass + ".class");
                return new ClassFormatError("'" + offendingClass.replace('/', '.') + "' is an API only class. You need to remove '" + url.toString().substring(9, url.toString().indexOf("!")) + "' from your classpath");
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            if (this.container == null) {
                this.initWeld();
            }
            if (this.startupException != null) {
                if (EjbUnitRule.this.method != null && EjbUnitRule.this.method.getAnnotation(Test.class).expected() == this.startupException.getClass()) {
                    return;
                }
                throw this.startupException;
            }
            System.setProperty("java.naming.factory.initial", "com.oneandone.cdiunit.internal.naming.CdiUnitContextFactory");
            InitialContext initialContext = new InitialContext();
            BeanManager beanManager = this.container.getBeanManager();
            initialContext.bind("java:comp/BeanManager", (Object)beanManager);
            try (CreationalContexts<Object> creationalContexts = new CreationalContexts<Object>(beanManager);){
                try {
                    Class.forName("javax.ejb.EJBContext");
                    creationalContexts.create(EjbUnitBeanInitializerClass.class, ApplicationScoped.class);
                    EjbInformationBean ejbInformationBean = (EjbInformationBean)creationalContexts.create(EjbInformationBean.class, ApplicationScoped.class);
                    ejbInformationBean.setApplicationExceptionDescriptions(EjbUnitRule.this.cdiTestConfig.getApplicationExceptionDescriptions());
                    Object test = creationalContexts.create(this.clazz, ApplicationScoped.class);
                    this.initWeldFields(test, test.getClass());
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Expected EJB to be present, when using EjbUnitRunner, therefore: could not init Startups and Jms-Objects.");
                }
                this.next.evaluate();
            }
            finally {
                initialContext.close();
                this.weld.shutdown();
                this.container = null;
            }
        }

        public void initWeld() {
            block4: {
                if (this.startupException == null) {
                    try {
                        this.container = this.weld.initialize();
                    }
                    catch (Throwable e) {
                        if (this.startupException == null) {
                            this.startupException = e;
                        }
                        if (!(e instanceof ClassFormatError)) break block4;
                        throw e;
                    }
                }
            }
        }

        private void initWeldFields(Object newTestInstance, Class<?> clazzP) throws IllegalAccessException {
            if (clazzP.equals(Object.class)) {
                return;
            }
            for (Field f : clazzP.getDeclaredFields()) {
                f.setAccessible(true);
                if (f.getAnnotation(Inject.class) != null) {
                    f.set(this.testInstance, f.get(newTestInstance));
                    continue;
                }
                if (f.get(newTestInstance) == null || f.get(this.testInstance) != null) continue;
                f.set(this.testInstance, f.get(newTestInstance));
            }
            this.initWeldFields(newTestInstance, clazzP.getSuperclass());
        }
    }
}

