/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;

@Qualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
public @interface ResourceQualifier {
    public String name() default "";

    public String lookup() default "";

    public String mappedName() default "";

    public static class ResourceQualifierLiteral
    extends AnnotationLiteral<ResourceQualifier>
    implements ResourceQualifier {
        private static final long serialVersionUID = 7107494117787642445L;
        private final String name;
        private final String mappedName;
        private final String lookup;

        public ResourceQualifierLiteral(String name, String lookup, String mappedName) {
            this.name = name;
            this.mappedName = mappedName;
            this.lookup = lookup;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String lookup() {
            return this.lookup;
        }

        @Override
        public String mappedName() {
            return this.mappedName;
        }

        @Override
        public String toString() {
            return "ResourceQualifierLiteral{name='" + this.name + '\'' + ", mappedName='" + this.mappedName + '\'' + ", lookup='" + this.lookup + '\'' + '}';
        }
    }
}

