/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.camunda;

import com.oneandone.ejbcdiunit.camunda.CdiUnitContextAssociationManager;
import com.oneandone.ejbcdiunit.camunda.EjbCamundaUnitRule;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class CdiProcessEngineTestCase {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    @Inject
    protected BeanManager beanManager;
    @Inject
    protected ProcessEngine processEngine;
    @Inject
    protected FormService formService;
    @Inject
    protected HistoryService historyService;
    @Inject
    protected IdentityService identityService;
    @Inject
    protected ManagementService managementService;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected RuntimeService runtimeService;
    @Inject
    protected TaskService taskService;
    @Inject
    protected AuthorizationService authorizationService;
    @Inject
    protected FilterService filterService;
    @Inject
    protected ExternalTaskService externalTaskService;
    @Inject
    protected CaseService caseService;
    @Inject
    protected DecisionService decisionService;
    @Inject
    protected BusinessProcess businessProcess;
    @Inject
    CdiUnitContextAssociationManager.ApplicationScopedAssociation applicationScopedAssociation;
    private EjbCamundaUnitRule ejbCamundaUnitRule;

    @Rule
    public EjbCamundaUnitRule getEjbCamundaUnitRule() {
        if (this.ejbCamundaUnitRule != null) {
            return this.ejbCamundaUnitRule;
        }
        this.ejbCamundaUnitRule = new EjbCamundaUnitRule(this);
        return this.ejbCamundaUnitRule;
    }

    protected <T> T getBeanInstance(Class<T> clazz) {
        return (T)ProgrammaticBeanLookup.lookup(clazz);
    }

    protected Object getBeanInstance(String name) {
        return ProgrammaticBeanLookup.lookup((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = this.ejbCamundaUnitRule.getProcessEngineConfiguration().getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    areJobsAvailable = this.areJobsAvailable();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobExecutor jobExecutor = this.ejbCamundaUnitRule.getProcessEngineConfiguration().getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while waiting on condition: " + e.getMessage(), (Throwable)e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public boolean areJobsAvailable() {
        return !this.managementService.createJobQuery().executable().list().isEmpty();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

