/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.camunda;

import com.oneandone.ejbcdiunit.AsynchronousManager;
import java.util.Iterator;
import java.util.List;
import org.camunda.bpm.engine.cdi.impl.util.ProgrammaticBeanLookup;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbCdiUnitJobExecutor
extends JobExecutor {
    static ThreadLocal<EjbCdiUnitJobExecutor> executorInThread = new ThreadLocal();
    Logger logger = LoggerFactory.getLogger((String)"EjbCdiUnitJobExecutor");
    AsynchronousManager asynchronousManager;

    public static void initThreadLocal() {
        EjbCdiUnitJobExecutor executor = executorInThread.get();
        if (executor != null) {
            executorInThread.set(null);
            executor.startExecutingJobs();
        }
    }

    public AsynchronousManager getAsynchronousManager() {
        return this.asynchronousManager;
    }

    protected void startExecutingJobs() {
        if (executorInThread.get() != null) {
            this.asynchronousManager = executorInThread.get().getAsynchronousManager();
        } else {
            this.asynchronousManager = (AsynchronousManager)ProgrammaticBeanLookup.lookup(AsynchronousManager.class);
            executorInThread.set(this);
        }
        this.asynchronousManager.addMultipleHandler((Runnable)new SequentialJobAcquisitionRunnable(this){

            public synchronized void run() {
                this.acquisitionContext.reset();
                this.acquisitionContext.setAcquisitionTime(System.currentTimeMillis());
                this.clearJobAddedNotification();
                Iterator engineIterator = this.jobExecutor.engineIterator();
                JobAcquisitionStrategy acquisitionStrategy = new JobAcquisitionStrategy(){

                    public void reconfigure(JobAcquisitionContext context) {
                    }

                    public long getWaitTime() {
                        return 0L;
                    }

                    public int getNumJobsToAcquire(String processEngine) {
                        return 100;
                    }
                };
                try {
                    while (engineIterator.hasNext()) {
                        ProcessEngineImpl currentProcessEngine = (ProcessEngineImpl)engineIterator.next();
                        if (!this.jobExecutor.hasRegisteredEngine(currentProcessEngine)) continue;
                        AcquiredJobs acquiredJobs = this.acquireJobs(this.acquisitionContext, acquisitionStrategy, currentProcessEngine);
                        this.executeJobs(this.acquisitionContext, currentProcessEngine, acquiredJobs);
                    }
                }
                catch (Exception e) {
                    EjbCdiUnitJobExecutor.this.logger.error("Exception during Aquisition", (Throwable)e);
                    this.acquisitionContext.setAcquisitionException(e);
                }
                this.acquisitionContext.setJobAdded(this.isJobAdded);
                this.configureNextAcquisitionCycle(this.acquisitionContext, acquisitionStrategy);
                long waitTime = acquisitionStrategy.getWaitTime();
                waitTime = Math.max(0L, this.acquisitionContext.getAcquisitionTime() + waitTime - System.currentTimeMillis());
            }
        });
        System.out.println("output");
    }

    protected void stopExecutingJobs() {
        try {
            if (this.asynchronousManager.thereAreOnces()) {
                this.logger.error("There are jobs left to be executed");
            }
        }
        catch (Throwable thw) {
            this.logger.error("exception in stopping executor", thw);
        }
        executorInThread.set(null);
    }

    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        this.asynchronousManager.addOneTimeHandler(this.getExecuteJobsRunnable(jobIds, processEngine));
    }
}

