/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.camunda;

import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import com.oneandone.ejbcdiunit.persistence.TestTransaction;
import javax.ejb.TransactionAttributeType;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneTransactionContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbCdiUnitTransactionContextFactory
implements TransactionContextFactory {
    static Logger logger = LoggerFactory.getLogger((String)"EjbCdiUnitTransactionContextFactory");
    public final boolean started;

    public EjbCdiUnitTransactionContextFactory() {
        this.started = true;
    }

    public TransactionContext openTransactionContext(CommandContext commandContext) {
        return new EjbCdiUnitTransactionContext(commandContext);
    }

    static class EjbCdiUnitTransactionContext
    extends StandaloneTransactionContext {
        TestTransaction testTransaction;

        public EjbCdiUnitTransactionContext(CommandContext commandContext) {
            super(commandContext);
            logger.trace("********* Start context for {}", (Object)Thread.currentThread().getName());
            new SimulatedTransactionManager().push(TransactionAttributeType.NOT_SUPPORTED);
        }

        public void commit() {
            logger.trace("********* Commit context for {}", (Object)Thread.currentThread().getName());
            super.commit();
            try {
                new SimulatedTransactionManager().pop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void rollback() {
            logger.trace("******* Rollback context for {}", (Object)Thread.currentThread().getName());
            super.rollback();
            try {
                new SimulatedTransactionManager().setRollbackOnly(false);
                new SimulatedTransactionManager().pop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isTransactionActive() {
            try {
                return super.isTransactionActive() && this.testTransaction.getStatus() != 6;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

