/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cdiunit;

import com.oneandone.ejbcdiunit.CdiTestConfig;
import com.oneandone.ejbcdiunit.CreationalContexts;
import com.oneandone.ejbcdiunit.EjbUnitTransactionServices;
import com.oneandone.ejbcdiunit.SupportEjbExtended;
import com.oneandone.ejbcdiunit.cdiunit.Weld11TestUrlDeployment;
import com.oneandone.ejbcdiunit.cdiunit.WeldTestConfig;
import com.oneandone.ejbcdiunit.cdiunit.WeldTestUrlDeployment;
import com.oneandone.ejbcdiunit.internal.EjbInformationBean;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.reflection.Formats;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class CdiRunner
extends BlockJUnit4ClassRunner {
    private static final String ABSENT_CODE_PREFIX = "Absent Code attribute in method that is not native or abstract in class file ";
    protected Weld weld;
    protected WeldContainer container;
    protected Throwable startupException;
    protected FrameworkMethod frameworkMethod;
    private Class<?> clazz;

    public CdiRunner(Class<?> clazz) throws InitializationError {
        super(CdiRunner.checkClass(clazz));
        this.clazz = clazz;
    }

    private static Class<?> checkClass(Class<?> clazzP) {
        try {
            for (Method method : clazzP.getMethods()) {
                method.getReturnType();
                method.getParameterTypes();
                method.getParameterAnnotations();
            }
            for (AccessibleObject accessibleObject : clazzP.getFields()) {
                ((Field)accessibleObject).getType();
            }
        }
        catch (ClassFormatError e) {
            throw CdiRunner.parseClassFormatError(e);
        }
        return clazzP;
    }

    private static ClassFormatError parseClassFormatError(ClassFormatError e) {
        if (e.getMessage().startsWith(ABSENT_CODE_PREFIX)) {
            String offendingClass = e.getMessage().substring(ABSENT_CODE_PREFIX.length());
            URL url = CdiRunner.class.getClassLoader().getResource(offendingClass + ".class");
            return new ClassFormatError("'" + offendingClass.replace('/', '.') + "' is an API only class. You need to remove '" + url.toString().substring(9, url.toString().indexOf("!")) + "' from your classpath");
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createTest() throws Exception {
        try {
            String version = Formats.version((Package)WeldBootstrap.class.getPackage());
            if ("2.2.8 (Final)".equals(version) || "2.2.7 (Final)".equals(version)) {
                this.startupException = new Exception("Weld 2.2.8 and 2.2.7 are not supported. Suggest upgrading to 2.2.9");
            }
            final WeldTestConfig weldTestConfig = ((WeldTestConfig)new WeldTestConfig(this.clazz, this.frameworkMethod.getMethod()).addClass((Class)SupportEjbExtended.class)).addServiceConfig(new CdiTestConfig.ServiceConfig<EjbUnitTransactionServices>(TransactionServices.class, new EjbUnitTransactionServices()));
            this.weld = new Weld(){

                protected Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
                    try {
                        return new Weld11TestUrlDeployment(resourceLoader, (Bootstrap)bootstrap, weldTestConfig);
                    }
                    catch (IOException e) {
                        CdiRunner.this.startupException = e;
                        throw new RuntimeException(e);
                    }
                }

                protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
                    try {
                        return new WeldTestUrlDeployment(resourceLoader, bootstrap, weldTestConfig);
                    }
                    catch (IOException e) {
                        CdiRunner.this.startupException = e;
                        throw new RuntimeException(e);
                    }
                }
            };
            try {
                System.setProperty("java.naming.factory.initial", "com.oneandone.cdiunit.internal.naming.CdiUnitContextFactory");
                this.container = this.weld.initialize();
                InitialContext initialContext = new InitialContext();
                BeanManager beanManager = this.container.getBeanManager();
                initialContext.bind("java:comp/BeanManager", (Object)beanManager);
                try (CreationalContexts<EjbInformationBean> creationalContexts = new CreationalContexts<EjbInformationBean>(beanManager);){
                    EjbInformationBean ejbInformationBean = (EjbInformationBean)creationalContexts.create(EjbInformationBean.class, ApplicationScoped.class);
                    ejbInformationBean.setApplicationExceptionDescriptions(weldTestConfig.getApplicationExceptionDescriptions());
                }
                finally {
                    initialContext.close();
                }
            }
            catch (Throwable e) {
                if (this.startupException == null) {
                    this.startupException = e;
                }
                if (e instanceof ClassFormatError) {
                    throw e;
                }
            }
        }
        catch (ClassFormatError e) {
            this.startupException = CdiRunner.parseClassFormatError(e);
        }
        catch (Throwable e) {
            this.startupException = new Exception("Unable to start weld", e);
        }
        return this.createTest(this.clazz);
    }

    private <T> T createTest(Class<T> testClass) {
        Object t = this.container.instance().select(testClass, new Annotation[0]).get();
        return (T)t;
    }
}

