/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cdiunit;

import com.oneandone.cdiunit.BeanDeploymentArchiveImpl;
import com.oneandone.ejbcdiunit.CdiTestConfig;
import com.oneandone.ejbcdiunit.cdiunit.WeldTestConfig;
import com.oneandone.ejbcdiunit.cfganalyzer.CdiUnitAnalyzer;
import com.oneandone.ejbcdiunit.cfganalyzer.TestConfig;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.Scanning;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldTestUrlDeployment
implements Deployment {
    private static Logger log = LoggerFactory.getLogger(WeldTestUrlDeployment.class);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private Collection<Metadata<Extension>> extensions = new ArrayList<Metadata<Extension>>();
    private Set<URL> cdiClasspathEntries = new HashSet<URL>();

    public WeldTestUrlDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap, WeldTestConfig weldTestConfig) throws IOException {
        Class<?> testClass = weldTestConfig.getTestClass();
        Method testMethod = weldTestConfig.getTestMethod();
        CdiUnitAnalyzer cdiUnitAnalyzer = new CdiUnitAnalyzer();
        cdiUnitAnalyzer.analyze(testClass, testMethod, weldTestConfig);
        TestConfig testConfig = cdiUnitAnalyzer.getTestConfig();
        BeansXml beansXml = WeldTestUrlDeployment.createBeansXml();
        for (Metadata<String> metadata : testConfig.getEnabledInterceptors()) {
            beansXml.getEnabledInterceptors().add(metadata);
        }
        for (Metadata<String> metadata : testConfig.getEnabledDecorators()) {
            beansXml.getEnabledDecorators().add(metadata);
        }
        for (Metadata<String> metadata : testConfig.getEnabledAlternativeStereotypes()) {
            beansXml.getEnabledAlternativeStereotypes().add(metadata);
        }
        for (Metadata<String> metadata : testConfig.getAlternatives()) {
            beansXml.getEnabledAlternativeClasses().add(metadata);
        }
        this.beanDeploymentArchive = new BeanDeploymentArchiveImpl("cdi-unit" + UUID.randomUUID(), testConfig.getDiscoveredClasses(), beansXml);
        this.beanDeploymentArchive.getServices().add(ResourceLoader.class, (Service)resourceLoader);
        for (CdiTestConfig.ServiceConfig serviceConfig : weldTestConfig.getServiceConfigs()) {
            this.beanDeploymentArchive.getServices().add(serviceConfig.getServiceClass(), serviceConfig.getService());
        }
        for (Metadata metadata : testConfig.getExtensions()) {
            this.extensions.add((Metadata<Extension>)metadata);
        }
        log.trace("CDI-Unit discovered:");
        for (String string : testConfig.getDiscoveredClasses()) {
            if (string.startsWith("org.jglue.cdiunit.internal.")) continue;
            log.trace(string);
        }
    }

    private static Object annotatedDiscoveryMode() {
        try {
            return BeanDiscoveryMode.ANNOTATED;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private static BeansXml createBeansXml() {
        try {
            LocalBeansXmlImpl beansXmlImpl = new LocalBeansXmlImpl(new ArrayList<Metadata<String>>(), new ArrayList<Metadata<String>>(), new ArrayList<Metadata<String>>(), new ArrayList<Metadata<String>>(), Scanning.EMPTY_SCANNING, new URL("file:cdi-unit"), WeldTestUrlDeployment.annotatedDiscoveryMode(), "cdi-unit", false);
            return (BeansXml)Proxy.newProxyInstance(BeansXml.class.getClassLoader(), new Class[]{BeansXml.class}, (InvocationHandler)beansXmlImpl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.singletonList(this.beanDeploymentArchive);
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }

    public ServiceRegistry getServices() {
        return this.beanDeploymentArchive.getServices();
    }

    static class LocalBeansXmlImpl
    implements InvocationHandler {
        private final List enabledAlternatives;
        private final List enabledAlternativeStereotypes;
        private final List enabledDecorators;
        private final List enabledInterceptors;
        private final Scanning scanning;
        private final URL url;
        private final Object discoveryMode;
        private final String version;
        private final boolean isTrimmed;

        public LocalBeansXmlImpl(List<Metadata<String>> enabledAlternatives, List<Metadata<String>> enabledAlternativeStereotypes, List<Metadata<String>> enabledDecorators, List<Metadata<String>> enabledInterceptors, Scanning scanning, URL url, Object discoveryMode, String version, boolean isTrimmed) {
            this.enabledAlternatives = enabledAlternatives;
            this.enabledAlternativeStereotypes = enabledAlternativeStereotypes;
            this.enabledDecorators = enabledDecorators;
            this.enabledInterceptors = enabledInterceptors;
            this.scanning = scanning;
            this.url = url;
            this.discoveryMode = discoveryMode;
            this.version = version;
            this.isTrimmed = isTrimmed;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            switch (methodName = method.getName()) {
                case "getEnabledAlternativeClasses": {
                    return this.enabledAlternatives;
                }
                case "getEnabledAlternativeStereotypes": {
                    return this.enabledAlternativeStereotypes;
                }
                case "getEnabledDecorators": {
                    return this.enabledDecorators;
                }
                case "getEnabledInterceptors": {
                    return this.enabledInterceptors;
                }
                case "getScanning": {
                    return this.scanning;
                }
                case "getUrl": {
                    return this.url;
                }
                case "getBeanDiscoveryMode": {
                    return this.discoveryMode;
                }
                case "getVersion": {
                    return this.version;
                }
                case "isTrimmed": {
                    return this.isTrimmed;
                }
            }
            throw new RuntimeException("unknown method " + methodName + " of BeansXmlImpl");
        }
    }
}

