/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cfganalyzer;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jboss.resteasy.spi.NotImplementedYetException;

public class CdiRelBuilder {
    private final RootRel rootRel;

    public RootRel getRootRel() {
        return this.rootRel;
    }

    public CdiRelBuilder(Collection<Class<?>> initialClasses) throws AnalyzerException {
        this.rootRel = new RootRel(initialClasses);
        RelFactory relFactory = new RelFactory();
        for (Class<?> clazz : initialClasses) {
            relFactory.createBeanFromClass(this.rootRel, clazz);
        }
        this.rootRel.setBeanClasses(relFactory.beanClasses);
    }

    public static class AnalyzerException
    extends Exception {
        public static final long serialVersionUID = -4731804312861785688L;
    }

    public static class NotSupportedTypeYet
    extends AnalyzerException {
        public static final long serialVersionUID = -7645090605110467195L;
    }

    public static class RelFactory {
        Map<Class<?>, Intermediate> beanClasses = new HashMap();

        SimpleClassRel createSimple(Intermediate parent, Class<?> c) throws AnalyzerException {
            SimpleClassRel r = new SimpleClassRel(parent, c);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Intermediate createBeanFromClass(Intermediate parent, Class<?> c) throws AnalyzerException {
            if (this.beanClasses.containsKey(c)) {
                return this.beanClasses.get(c);
            }
            BaseIntermediateRel res = null;
            try {
                if (c.isInterface()) {
                    res = new SimpleClassRel(parent, c);
                } else {
                    BeanClassRel br = new BeanClassRel(parent, c);
                    res = br;
                    Type superClass = c.getGenericSuperclass();
                    if (superClass != null && superClass != Object.class) {
                        this.createBeanFromClass(br, (Class)superClass);
                    }
                    for (Field field : c.getDeclaredFields()) {
                        if (field.isAnnotationPresent(Inject.class)) {
                            this.createInjectField(br, field);
                            continue;
                        }
                        if (!field.isAnnotationPresent(Produces.class)) continue;
                        this.createProducedField(br, field);
                    }
                    for (AccessibleObject accessibleObject : c.getDeclaredConstructors()) {
                        if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
                        this.createInjectConstructor(br, (Constructor)accessibleObject);
                    }
                    for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                        if (!accessibleObject.isAnnotationPresent(Produces.class)) continue;
                        this.createProducerMethod(br, (Method)accessibleObject);
                    }
                }
                this.beanClasses.put(c, res);
            }
            catch (Throwable throwable) {
                this.beanClasses.put(c, res);
                throw throwable;
            }
            return res;
        }

        private void createProducerMethod(BeanClassRel r, Method method) throws AnalyzerException {
            ProducerMethodRel res = new ProducerMethodRel(r, method);
            for (Parameter p : method.getParameters()) {
                ParameterInjectRel pRel = this.createInjectParameter(res, p);
                res.add(pRel);
                Intermediate bean = this.createTypeBean(r, p.getParameterizedType());
                pRel.setBean(bean);
            }
        }

        private void createInjectConstructor(BeanClassRel r, Constructor constructor) throws AnalyzerException {
            ConstructorInjectRel res = new ConstructorInjectRel(r, constructor);
            for (Parameter p : constructor.getParameters()) {
                ParameterInjectRel pRel = this.createInjectParameter(r, p);
                res.add(pRel);
                Intermediate bean = this.createTypeBean(r, p.getParameterizedType());
                pRel.setBean(bean);
            }
        }

        private ParameterInjectRel createInjectParameter(Intermediate parent, Parameter p) {
            return new ParameterInjectRel(parent, p);
        }

        private InjectedFieldRel createInjectField(BeanClassRel r, Field field) throws AnalyzerException {
            if (field.getType().equals(Provider.class)) {
                throw new NotImplementedYetException();
            }
            if (field.getType().equals(Instance.class)) {
                throw new NotImplementedYetException();
            }
            InjectedFieldRel res = new InjectedFieldRel(r, field);
            Intermediate bean = this.createTypeBean(r, field.getType());
            res.setBean(bean);
            return res;
        }

        private ProducerFieldRel createProducedField(BeanClassRel r, Field field) {
            return new ProducerFieldRel(r, field);
        }

        Intermediate createParameterized(Intermediate parent, ParameterizedType type) throws AnalyzerException {
            Intermediate raw = this.createBeanFromClass(parent, (Class)type.getRawType());
            for (Type arg : type.getActualTypeArguments()) {
                this.createTypeBean(parent, arg);
            }
            return raw;
        }

        Intermediate createTypeBean(Intermediate parent, Type type) throws AnalyzerException {
            if (type instanceof Class) {
                return this.createBeanFromClass(parent, (Class)type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                return this.createParameterized(parent, ptype);
            }
            throw new NotSupportedTypeYet();
        }
    }

    public static class ProducerMethodRel
    extends BaseIntermediateRel {
        protected Method m;

        public ProducerMethodRel(BeanClassRel r, Method method) {
            super(r, method.getReturnType());
            this.m = method;
        }

        @Override
        public RelType type() {
            return RelType.PRODUCER_METHOD;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }
    }

    public static class ParameterInjectRel
    extends BaseRel {
        protected Parameter p;
        private Intermediate bean;

        public ParameterInjectRel(Intermediate r, Parameter parameter) {
            super(r, parameter.getType());
            this.p = parameter;
        }

        @Override
        public RelType type() {
            return RelType.INJECTED_PARAMETER;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }

        public void setBean(Intermediate bean) {
            this.bean = bean;
        }

        public Intermediate getBean() {
            return this.bean;
        }
    }

    public static class ConstructorInjectRel
    extends BaseIntermediateRel {
        protected Constructor m;

        public ConstructorInjectRel(BeanClassRel r, Constructor constructor) {
            super(r, constructor.getDeclaringClass());
            this.m = constructor;
        }

        @Override
        public RelType type() {
            return RelType.CONSTRUCTOR_INJECT;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }
    }

    public static class ProducerFieldRel
    extends BaseFieldRel {
        public ProducerFieldRel(BeanClassRel r, Field field) {
            super(r, field);
        }

        @Override
        public RelType type() {
            return RelType.PRODUCER_FIELD;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }
    }

    public static class InjectedFieldRel
    extends BaseFieldRel {
        private Intermediate bean;

        public InjectedFieldRel(BeanClassRel r, Field field) {
            super(r, field);
        }

        @Override
        public RelType type() {
            return RelType.INJECTED_FIELD;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }

        public void setBean(Intermediate bean) {
            this.bean = bean;
        }

        public Intermediate getBean() {
            return this.bean;
        }
    }

    public static abstract class BaseFieldRel
    extends BaseRel {
        protected Field f;

        public BaseFieldRel(BeanClassRel r, Field field) {
            super(r, field.getType());
            this.f = field;
        }
    }

    public static class RootRel
    implements Intermediate {
        private final Collection<Class<?>> initialClasses;
        private Map<Class<?>, Intermediate> beanClasses;
        private List<Rel> children = new ArrayList<Rel>();

        public RootRel(Collection<Class<?>> initialClasses) {
            this.initialClasses = initialClasses;
        }

        @Override
        public Rel parent() {
            return null;
        }

        @Override
        public Class<?> getAffectedClass() {
            return null;
        }

        @Override
        public List<Rel> children() {
            return this.children;
        }

        @Override
        public RelType type() {
            return RelType.ROOT;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }

        public void setBeanClasses(Map<Class<?>, Intermediate> beanClasses) {
            this.beanClasses = beanClasses;
        }

        public Map<Class<?>, Intermediate> getBeanClasses() {
            return this.beanClasses;
        }
    }

    public static class SimpleClassRel
    extends BaseIntermediateRel {
        public SimpleClassRel(Intermediate parent, Class<?> affectedClass) {
            super(parent, affectedClass);
        }

        @Override
        public RelType type() {
            return RelType.SIMPLE_BEAN;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }
    }

    public static class BeanClassRel
    extends BaseIntermediateRel {
        public BeanClassRel(Intermediate parent, Class<?> affectedClass) {
            super(parent, affectedClass);
        }

        @Override
        public RelType type() {
            return RelType.ADDED_BEAN;
        }

        @Override
        public Object accept(RelVisitor visitor, Object p) {
            return visitor.visit(this, p);
        }
    }

    public static abstract class BaseIntermediateRel
    extends BaseRel
    implements Intermediate {
        List<Rel> children = new ArrayList<Rel>();

        public BaseIntermediateRel(Intermediate parent, Class<?> affectedClass) {
            super(parent, affectedClass);
        }

        @Override
        public List<Rel> children() {
            return this.children;
        }
    }

    public static abstract class BaseRel
    implements Rel {
        private Rel parent;
        Class<?> affectedClass;

        public BaseRel(Intermediate parent, Class<?> affectedClass) {
            Objects.requireNonNull(parent);
            this.parent = parent;
            this.affectedClass = affectedClass;
            if (parent != null) {
                parent.add(this);
            }
        }

        @Override
        public Class<?> getAffectedClass() {
            return this.affectedClass;
        }

        @Override
        public Rel parent() {
            return this.parent;
        }
    }

    public static interface Intermediate
    extends Rel {
        public List<Rel> children();

        default public void add(Rel rel) {
            Objects.requireNonNull(rel);
            this.children().add(rel);
        }
    }

    public static interface Rel {
        public Rel parent();

        public RelType type();

        public Class<?> getAffectedClass();

        public Object accept(RelVisitor var1, Object var2);
    }

    public static interface RelVisitor {
        public Object visit(ProducerFieldRel var1, Object var2);

        public Object visit(ProducerMethodRel var1, Object var2);

        public Object visit(InjectedFieldRel var1, Object var2);

        public Object visit(BeanClassRel var1, Object var2);

        public Object visit(SimpleClassRel var1, Object var2);

        public Object visit(ConstructorInjectRel var1, Object var2);

        public Object visit(ParameterInjectRel var1, Object var2);

        public Object visit(RootRel var1, Object var2);
    }

    public static enum RelType {
        ROOT,
        PRODUCER_FIELD,
        PRODUCER_METHOD,
        INJECTED_FIELD,
        INJECTED_PARAMETER,
        ADDED_BEAN,
        ADDED_CLASS,
        ADDED_ANNOTATION,
        SIMPLE_BEAN,
        CONSTRUCTOR_INJECT;

    }
}

