/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cfganalyzer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClasspathSetPopulator {
    Logger log = LoggerFactory.getLogger((String)"ClasspathSetPopulator");

    ClasspathSetPopulator() {
    }

    private Class<?> loadClass(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isDirectory(URL classpathEntry) {
        try {
            return new File(classpathEntry.toURI()).isDirectory();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    private URL getClasspathURL(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        return codeSource != null ? codeSource.getLocation() : null;
    }

    private static Set<URL> getEntriesFromManifestClasspath(URL url) throws IOException {
        HashSet<URL> manifestURLs = new HashSet<URL>();
        try (InputStream in = url.openStream();
             JarInputStream jar = new JarInputStream(in);){
            String classpath;
            Manifest manifest = jar.getManifest();
            if (manifest != null && (classpath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
                String[] manifestEntries;
                for (String entry : manifestEntries = classpath.split(" ?file:")) {
                    if (entry.length() <= 0) continue;
                    manifestURLs.add(new URL("file:" + entry));
                }
            }
        }
        return manifestURLs;
    }

    public void invoke(Set<URI> cdiClasspathEntries) throws IOException {
        String systemClasspath = System.getProperty("java.class.path");
        String pathseparator = System.getProperty("path.separator");
        String[] classpathes = systemClasspath.split(pathseparator);
        HashSet<URI> classpathEntries = new HashSet<URI>();
        for (String path : classpathes) {
            classpathEntries.add(new File(path).toURI());
        }
        try (JarInputStream firstEntry = new JarInputStream(((URI)classpathEntries.iterator().next()).toURL().openStream());){
            String classpath;
            Manifest manifest = firstEntry.getManifest();
            if (manifest != null && (classpath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
                String[] manifestEntries;
                for (String entry : manifestEntries = classpath.split(" ?file:")) {
                    if (entry.isEmpty()) continue;
                    classpathEntries.add(new URL("file:" + entry).toURI());
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        for (URI uri : classpathEntries) {
            URL url = uri.toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{url}, null);
            try {
                if (url.getFile().endsWith("/classes/")) {
                    URL webInfBeans = new URL(url, "../../src/main/WEB-INF/beans.xml");
                    try {
                        try {
                            webInfBeans.openConnection().connect();
                        }
                        catch (FileNotFoundException fnfe) {
                            webInfBeans = new URL(url, "../../src/main/webapp/WEB-INF/beans.xml");
                            webInfBeans.openConnection().connect();
                        }
                        cdiClasspathEntries.add(url.toURI());
                    }
                    catch (IOException fnfe) {
                        // empty catch block
                    }
                }
                URL resource = cl.getResource("META-INF/beans.xml");
                boolean ejbCdiUnit = url.toURI().equals(ClasspathSetPopulator.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (!ejbCdiUnit && resource == null && !this.isDirectory(url)) continue;
                cdiClasspathEntries.add(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            finally {
                try {
                    Method method = cl.getClass().getMethod("close", new Class[0]);
                    method.invoke((Object)cl, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            }
        }
        this.log.trace("CDI classpath classpathEntries discovered:");
        for (URI uri : cdiClasspathEntries) {
            this.log.trace("{}", (Object)uri);
        }
    }
}

