/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cfganalyzer;

import com.oneandone.ejbcdiunit.CdiTestConfig;
import com.oneandone.ejbcdiunit.internal.ApplicationExceptionDescription;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class EjbJarParser {
    private Logger log = LoggerFactory.getLogger((String)"EjbJarParser");
    private final CdiTestConfig config;
    private final URL url;

    public EjbJarParser(CdiTestConfig config, URL url) {
        this.config = config;
        this.url = url;
    }

    public void invoke() throws IOException {
        block48: {
            try (URLClassLoader cl = new URLClassLoader(new URL[]{this.url}, null);){
                URL resource = cl.getResource("WEB-INF/ejb-jar.xml");
                if (resource == null) {
                    resource = cl.getResource("META-INF/ejb-jar.xml");
                }
                if (resource == null && this.url.getFile().endsWith("/classes/")) {
                    resource = new URL(this.url, "../../src/main/webapp/WEB-INF/ejb-jar.xml");
                }
                if (resource == null) {
                    this.log.error("expected ejb-jar to be found in {}", (Object)this.url);
                    return;
                }
                try (InputStream inputStream = resource.openStream();){
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    Document ejbjar = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
                    Element documentElement = ejbjar.getDocumentElement();
                    if ("ejb-jar".equals(documentElement.getNodeName())) {
                        documentElement.normalize();
                        NodeList children = documentElement.getChildNodes();
                        for (int i = 0; i < children.getLength(); ++i) {
                            if (!"assembly-descriptor".equals(children.item(i).getNodeName())) continue;
                            NodeList assemblyDescriptor = children.item(i).getChildNodes();
                            for (int j = 0; j < assemblyDescriptor.getLength(); ++j) {
                                Node description = assemblyDescriptor.item(j);
                                if (!"application-exception".equals(description.getNodeName())) continue;
                                ApplicationExceptionDescription applicationExceptionDescription = new ApplicationExceptionDescription();
                                block37: for (int k = 0; k < description.getChildNodes().getLength(); ++k) {
                                    Node attribute = description.getChildNodes().item(k);
                                    String value = attribute.getTextContent();
                                    switch (attribute.getNodeName()) {
                                        case "exception-class": {
                                            applicationExceptionDescription.setClassName(value.trim());
                                            continue block37;
                                        }
                                        case "rollback": {
                                            applicationExceptionDescription.setRollback("true".equals(value.toLowerCase().trim()));
                                            continue block37;
                                        }
                                        case "inherited": {
                                            applicationExceptionDescription.setInherited("true".equals(value.toLowerCase().trim()));
                                            continue block37;
                                        }
                                        case "#text": {
                                            continue block37;
                                        }
                                        default: {
                                            throw new RuntimeException("unexpected attribute in ejb-jar: " + attribute.getNodeName());
                                        }
                                    }
                                }
                                this.config.getApplicationExceptionDescriptions().add(applicationExceptionDescription);
                            }
                            break block48;
                        }
                        break block48;
                    }
                    this.log.error("expected ejb-jar-element to be found in {}", (Object)resource);
                }
                catch (ParserConfigurationException | SAXException e) {
                    this.log.error("parsing ejb-jar", (Throwable)e);
                }
            }
        }
    }
}

