/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.cfganalyzer;

import com.oneandone.ejbcdiunit.CdiTestConfig;
import com.oneandone.ejbcdiunit.cdiunit.EjbJarClasspath;
import com.oneandone.ejbcdiunit.cdiunit.ExcludedClasses;
import com.oneandone.ejbcdiunit.cfganalyzer.ClasspathSetPopulator;
import com.oneandone.ejbcdiunit.cfganalyzer.EjbJarParser;
import com.oneandone.ejbcdiunit.cfganalyzer.TestConfig;
import com.oneandone.ejbcdiunit.internal.TypesScanner;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.decorator.Decorator;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.interceptor.Interceptor;
import org.easymock.Mock;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jglue.cdiunit.ActivatedAlternatives;
import org.jglue.cdiunit.AdditionalClasses;
import org.jglue.cdiunit.AdditionalClasspaths;
import org.jglue.cdiunit.AdditionalPackages;
import org.reflections8.Configuration;
import org.reflections8.ReflectionUtils;
import org.reflections8.Reflections;
import org.reflections8.scanners.Scanner;
import org.reflections8.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestConfigAnalyzer {
    private static Logger log = LoggerFactory.getLogger(TestConfigAnalyzer.class);
    protected final TestConfig testConfig = new TestConfig();
    protected Set<Class<?>> classesToIgnore;
    private Set<Class<?>> classesToProcess = new LinkedHashSet();
    private Set<Class<?>> classesProcessed = new HashSet();
    private boolean analyzeStarted = false;
    private static Constructor metaDataConstructor;
    protected String weldVersion;

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    protected <T> Metadata<T> createMetadata(T value, String location) {
        try {
            return new MetadataImpl(value, location);
        }
        catch (NoClassDefFoundError e) {
            try {
                Class<?> oldClass = Class.forName("org.jboss.weld.metadata.MetadataImpl");
                Constructor<?> ctor = oldClass.getConstructor(Object.class, String.class);
                return (Metadata)ctor.newInstance(value, location);
            }
            catch (ReflectiveOperationException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public Set<String> getDiscoveredClasses() {
        return this.testConfig.getDiscoveredClasses();
    }

    public Set<Class<?>> getClassesToProcess() {
        return this.classesToProcess;
    }

    public Set<Class<?>> getClassesToIgnore() {
        return this.classesToIgnore;
    }

    private void checkSetAnalyzeStarted() {
        if (this.analyzeStarted) {
            throw new RuntimeException("Can use Analyzer only once");
        }
        this.analyzeStarted = true;
    }

    public void analyze(Class<?> testClass) throws IOException {
        this.analyze(testClass, null, new CdiTestConfig());
    }

    public void analyze(Class<?> testClass, CdiTestConfig config) throws IOException {
        this.analyze(testClass, null, config);
    }

    public void analyze(Class<?> testClass, Method testMethod, CdiTestConfig config) throws IOException {
        this.checkSetAnalyzeStarted();
        this.init(testClass, config);
        this.populateCdiClasspathSet();
        this.initContainerSpecific(testClass, testMethod);
        this.transferConfig(config);
        while (!this.classesToProcess.isEmpty()) {
            Class<?> c = this.classesToProcess.iterator().next();
            if (!(!this.isCdiClass(c) && !Extension.class.isAssignableFrom(c) || this.classesProcessed.contains(c) || c.isPrimitive() || this.classesToIgnore.contains(c))) {
                ExcludedClasses excludedClasses;
                ActivatedAlternatives alternativeClasses;
                AdditionalPackages additionalPackages;
                EjbJarClasspath ejbJarClasspath;
                AdditionalClasspaths additionalClasspaths;
                AdditionalClasses additionalClasses;
                this.classesProcessed.add(c);
                if (!c.isAnnotation()) {
                    this.testConfig.getDiscoveredClasses().add(c.getName());
                }
                if (Extension.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                    try {
                        this.testConfig.getExtensions().add(this.createMetadata((Extension)c.newInstance(), c.getName()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (c.isAnnotationPresent(Interceptor.class)) {
                    this.testConfig.getEnabledInterceptors().add(this.createMetadata(c.getName(), c.getName()));
                }
                if (c.isAnnotationPresent(Decorator.class)) {
                    this.testConfig.getEnabledDecorators().add(this.createMetadata(c.getName(), c.getName()));
                }
                if (this.isAlternativeStereotype(c)) {
                    this.testConfig.getEnabledAlternativeStereotypes().add(this.createMetadata(c.getName(), c.getName()));
                }
                if ((additionalClasses = c.getAnnotation(AdditionalClasses.class)) != null) {
                    for (Class<?> supportClass : additionalClasses.value()) {
                        this.classesToProcess.add(supportClass);
                    }
                    for (String lateBound : additionalClasses.late()) {
                        try {
                            Class<?> clazz = Class.forName(lateBound);
                            this.classesToProcess.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if ((additionalClasspaths = c.getAnnotation(AdditionalClasspaths.class)) != null) {
                    for (Class<?> additionalClasspath : additionalClasspaths.value()) {
                        this.addClassPath(additionalClasspath);
                    }
                }
                if ((ejbJarClasspath = c.getAnnotation(EjbJarClasspath.class)) != null && this.testConfig.getEjbJarClasspathExample() == null) {
                    this.testConfig.setEjbJarClasspathExample(ejbJarClasspath.value());
                    if (this.testConfig.getEjbJarClasspathExample() != null) {
                        URL path = this.testConfig.getEjbJarClasspathExample().getProtectionDomain().getCodeSource().getLocation();
                        this.addDeploymentDescriptor(config, path);
                    }
                }
                if ((additionalPackages = c.getAnnotation(AdditionalPackages.class)) != null) {
                    for (Class<?> additionalPackage : additionalPackages.value()) {
                        this.addPackage(additionalPackage);
                    }
                }
                if ((alternativeClasses = c.getAnnotation(ActivatedAlternatives.class)) != null) {
                    for (Class<?> alternativeClass : alternativeClasses.value()) {
                        this.addAlternative(alternativeClass);
                    }
                }
                if ((excludedClasses = c.getAnnotation(ExcludedClasses.class)) != null) {
                    if (this.belongsTo(c, testClass)) {
                        for (Class<?> excludedClass : excludedClasses.value()) {
                            if (this.classesProcessed.contains(excludedClass)) {
                                throw new RuntimeException("Trying to exclude already processed class: " + excludedClass);
                            }
                            this.classesToIgnore.add(excludedClass);
                        }
                    } else {
                        throw new RuntimeException("Trying to exclude in not toplevelclass: " + c);
                    }
                }
                for (Annotation a : c.getAnnotations()) {
                    if (a.annotationType().getPackage().getName().equals("org.jglue.cdiunit")) continue;
                    this.classesToProcess.add(a.annotationType());
                }
                this.analyzeClass(c);
            }
            this.classesToProcess.remove(c);
        }
    }

    private void analyzeClass(Class<?> c) {
        Type superClass = c.getGenericSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.addClassesToProcess(superClass);
        }
        for (Field field : c.getDeclaredFields()) {
            if (field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(Produces.class)) {
                this.addClassesToProcess(field.getGenericType());
            }
            if (!field.getType().equals(Provider.class) && !field.getType().equals(Instance.class)) continue;
            this.addClassesToProcess(field.getGenericType());
        }
        for (AccessibleObject accessibleObject : c.getDeclaredConstructors()) {
            if (accessibleObject.isAnnotationPresent(Produces.class)) {
                log.warn("invalid produces at constructor {}", (Object)((Constructor)accessibleObject).toGenericString());
            }
            if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
            for (Type param : ((Constructor)accessibleObject).getGenericParameterTypes()) {
                this.addClassesToProcess(param);
            }
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(Inject.class) && !accessibleObject.isAnnotationPresent(Produces.class)) continue;
            for (Type param : ((Method)accessibleObject).getGenericParameterTypes()) {
                this.addClassesToProcess(param);
            }
            this.addClassesToProcess(((Method)accessibleObject).getGenericReturnType());
        }
    }

    private void transferConfig(CdiTestConfig config) throws MalformedURLException {
        this.classesToProcess.addAll(config.getAdditionalClasses());
        for (Class<?> c : config.getAdditionalClassPathes()) {
            this.addClassPath(c);
        }
        for (Class<?> c : config.getAdditionalClassPackages()) {
            this.addPackage(c);
        }
        for (Class<?> c : config.getActivatedAlternatives()) {
            this.addAlternative(c);
        }
    }

    protected abstract void initContainerSpecific(Class<?> var1, Method var2);

    protected void init(Class<?> testClass, CdiTestConfig config) {
        this.testConfig.getDiscoveredClasses().add(testClass.getName());
        this.classesToIgnore = this.findMockedClassesOfTest(testClass);
        this.classesToIgnore.addAll(config.getExcludedClasses());
        this.classesToProcess.add(testClass);
        this.weldVersion = config.weldVersion;
    }

    private boolean belongsTo(Class<?> c, Class<?> testClass) {
        if (testClass.equals(Object.class)) {
            return false;
        }
        if (c.equals(testClass)) {
            return true;
        }
        return this.belongsTo(c, testClass.getSuperclass());
    }

    private void addAlternative(Class<?> alternativeClass) {
        this.classesToProcess.add(alternativeClass);
        if (!this.isAlternativeStereotype(alternativeClass)) {
            this.testConfig.getAlternatives().add(this.createMetadata(alternativeClass.getName(), alternativeClass.getName()));
        }
    }

    private void addPackage(Class<?> additionalPackage) throws MalformedURLException {
        final String packageName = additionalPackage.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new TypesScanner()}).setUrls(new URL[]{additionalPackage.getProtectionDomain().getCodeSource().getLocation()}).filterInputsBy((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String input) {
                return input.startsWith(packageName) && !input.substring(packageName.length() + 1, input.length() - 6).contains(".");
            }
        }));
        this.classesToProcess.addAll(ReflectionUtils.forNames((Iterable)reflections.getStore().get(TypesScanner.class.getSimpleName()).keySet(), (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
    }

    private void addClassPath(Class<?> additionalClasspath) throws MalformedURLException {
        URL path = additionalClasspath.getProtectionDomain().getCodeSource().getLocation();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new TypesScanner()}).setUrls(new URL[]{path}));
        this.classesToProcess.addAll(ReflectionUtils.forNames((Iterable)reflections.getStore().get(TypesScanner.class.getSimpleName()).keySet(), (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()}));
        try {
            this.testConfig.getCdiClasspathEntries().add(path.toURI());
        }
        catch (URISyntaxException e) {
            new MalformedURLException(e.getMessage());
        }
    }

    private void addClassesToProcess(Type type) {
        if (type instanceof Class) {
            this.classesToProcess.add((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            this.classesToProcess.add((Class)ptype.getRawType());
            for (Type arg : ptype.getActualTypeArguments()) {
                this.addClassesToProcess(arg);
            }
        }
    }

    private Set<Class<?>> findMockedClassesOfTest(Class<?> testClass) {
        HashSet mockedClasses = new HashSet();
        Class<?> actClass = testClass;
        while (!actClass.equals(Object.class)) {
            this.findMockedClassesOfTest(actClass, mockedClasses);
            actClass = actClass.getSuperclass();
        }
        return mockedClasses;
    }

    private Set<Class<?>> findMockedClassesOfTest(Class<?> testClass, Set<Class<?>> mockedClasses) {
        Class<?> type;
        try {
            for (Field field : testClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(org.mockito.Mock.class)) continue;
                type = field.getType();
                mockedClasses.add(type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            for (Field field : testClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Mock.class)) continue;
                type = field.getType();
                mockedClasses.add(type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return mockedClasses;
    }

    private void addDeploymentDescriptor(CdiTestConfig config, URL url) throws IOException {
        new EjbJarParser(config, url).invoke();
    }

    private void populateCdiClasspathSet() throws IOException {
        new ClasspathSetPopulator().invoke(this.testConfig.getCdiClasspathEntries());
    }

    private boolean isCdiClass(Class<?> c) {
        if (c.getProtectionDomain().getCodeSource() == null) {
            return false;
        }
        URL location = c.getProtectionDomain().getCodeSource().getLocation();
        boolean isCdi = false;
        try {
            isCdi = this.testConfig.getCdiClasspathEntries().contains(location.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return isCdi;
    }

    private boolean isAlternativeStereotype(Class<?> c) {
        return c.isAnnotationPresent(Stereotype.class) && c.isAnnotationPresent(Alternative.class);
    }
}

