/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.internal;

import com.oneandone.ejbcdiunit.AsynchronousManager;
import com.oneandone.ejbcdiunit.internal.EjbAsynchronous;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.Asynchronous;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@EjbAsynchronous
public class AsynchronousMethodInterceptor {
    @Inject
    AsynchronousManager asynchronousManager;
    Logger logger = LoggerFactory.getLogger((String)"AsynchronousMethodInterceptor");
    private static ThreadLocal<Boolean> inInvoking = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    @AroundInvoke
    public Object invoking(InvocationContext ctx) throws Exception {
        boolean classIsAsynchronous;
        if (inInvoking.get().booleanValue()) {
            return ctx.proceed();
        }
        this.logger.info("calling AsynchronousMethodIntercepted Class");
        Class<?> declaringClass = ctx.getMethod().getDeclaringClass();
        boolean bl = classIsAsynchronous = declaringClass.getAnnotation(Asynchronous.class) != null;
        if (!classIsAsynchronous && ctx.getMethod().getAnnotation(Asynchronous.class) == null) {
            return ctx.proceed();
        }
        final InterceptedAsyncResult asyncResult = new InterceptedAsyncResult();
        final Method m = ctx.getMethod();
        final Object[] p = ctx.getParameters();
        final Object target = ctx.getTarget();
        this.asynchronousManager.addOneTimeHandler(new Runnable(){

            @Override
            public void run() {
                try {
                    inInvoking.set(true);
                    Future res = (Future)m.invoke(target, p);
                    asyncResult.setDone();
                    asyncResult.setResult(res.get());
                }
                catch (Exception e) {
                    asyncResult.setException(e);
                }
                finally {
                    inInvoking.set(false);
                }
            }
        });
        asyncResult.isDone();
        return asyncResult;
    }

    public final class InterceptedAsyncResult
    implements Future<Object> {
        Object result = null;
        Throwable exception = null;
        boolean done = false;

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception1) {
            this.exception = exception1 instanceof ExecutionException ? exception1.getCause() : exception1;
            this.done = true;
        }

        public void setResult(Object result1) {
            this.result = result1;
            this.done = true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            if (!AsynchronousMethodInterceptor.this.asynchronousManager.doesEnqueAsynchronousCalls()) {
                try {
                    AsynchronousMethodInterceptor.this.asynchronousManager.oneShotOnly();
                }
                catch (Throwable thw) {
                    this.exception = thw instanceof ExecutionException ? thw.getCause() : thw;
                }
            }
            return this.done || this.result != null || this.exception != null;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.innerGet();
        }

        private Object innerGet() throws ExecutionException {
            if (this.result == null) {
                this.isDone();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.innerGet();
        }

        public void setDone() {
            this.done = true;
        }
    }
}

