/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.internal;

import com.oneandone.ejbcdiunit.ResourceQualifier;
import com.oneandone.ejbcdiunit.SupportEjbExtended;
import com.oneandone.ejbcdiunit.cdiunit.EjbName;
import com.oneandone.ejbcdiunit.internal.DefaultLiteral;
import com.oneandone.ejbcdiunit.internal.EjbAsynchronous;
import com.oneandone.ejbcdiunit.internal.EjbTransactional;
import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import com.oneandone.ejbcdiunit.resourcesimulators.SessionContextSimulation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportEjbExtended
@ApplicationScoped
public class EjbExtensionExtended
implements Extension {
    Logger logger = LoggerFactory.getLogger((String)"CDI-Unit EJB-ExtensionExtended");
    private List<Class<?>> timerClasses = new ArrayList();
    private List<Class<?>> entityClasses = new ArrayList();
    private List<Class<?>> startupSingletons = new ArrayList();

    private static AnnotationLiteral<Default> createDefaultAnnotation() {
        return new AnnotationLiteral<Default>(){
            private static final long serialVersionUID = 1L;
        };
    }

    private static AnnotationLiteral<Dependent> createDependentAnnotation() {
        return new AnnotationLiteral<Dependent>(){
            private static final long serialVersionUID = 1L;
        };
    }

    private static AnnotationLiteral<ApplicationScoped> createApplicationScopedAnnotation() {
        return new AnnotationLiteral<ApplicationScoped>(){
            private static final long serialVersionUID = 1L;
        };
    }

    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }

    public List<Class<?>> getTimerClasses() {
        return this.timerClasses;
    }

    public List<Class<?>> getStartupSingletons() {
        return this.startupSingletons;
    }

    public <T> void processBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        new SimulatedTransactionManager().init();
    }

    private <T> void processClass(AnnotatedTypeBuilder<T> builder, String name, boolean isSingleton, boolean scopeIsPresent) {
        this.logger.trace("processing class: {} singleton: {} scopeIsPresent: {}", new Object[]{name, isSingleton, scopeIsPresent});
        if (!scopeIsPresent) {
            if (!isSingleton || builder.getJavaClass().getFields().length > 0) {
                builder.addToClass(EjbExtensionExtended.createDependentAnnotation());
            } else {
                builder.addToClass(EjbExtensionExtended.createApplicationScopedAnnotation());
            }
        }
        builder.addToClass(EjbExtensionExtended.createDefaultAnnotation());
        if (!name.isEmpty()) {
            builder.addToClass((Annotation)new EjbName.EjbNameLiteral(name));
        } else {
            builder.addToClass((Annotation)DefaultLiteral.INSTANCE);
        }
    }

    String beanNameOrName(EJB ejb) {
        if (!ejb.name().isEmpty()) {
            return ejb.name();
        }
        return ejb.beanName();
    }

    <T extends Annotation> T findAnnotation(Class<?> annotatedType, Class<T> annotation) {
        if (annotatedType.equals(Object.class)) {
            return null;
        }
        return annotatedType.getAnnotation(annotation);
    }

    <T extends Annotation> boolean isAnnotationPresent(Class<?> annotatedType, Class<T> annotation) {
        if (annotatedType.equals(Object.class)) {
            return false;
        }
        return annotatedType.isAnnotationPresent(annotation);
    }

    <T extends Annotation, X> boolean isAnnotationPresent(ProcessAnnotatedType<X> pat, Class<T> annotation) {
        return this.isAnnotationPresent(pat.getAnnotatedType().getJavaClass(), annotation);
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        Stateful stateful;
        Stateless stateless;
        this.logger.trace("processing annotated Type: " + pat.getAnnotatedType().getJavaClass().getName());
        boolean modified = false;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(annotatedType);
        boolean scopeIsPresent = annotatedType.isAnnotationPresent(ApplicationScoped.class) || annotatedType.isAnnotationPresent(Dependent.class) || annotatedType.isAnnotationPresent(RequestScoped.class) || annotatedType.isAnnotationPresent(SessionScoped.class);
        Entity entity = (Entity)annotatedType.getAnnotation(Entity.class);
        if (entity != null) {
            this.entityClasses.add(annotatedType.getJavaClass());
        }
        if ((stateless = this.findAnnotation(annotatedType.getJavaClass(), Stateless.class)) != null) {
            this.processClass(builder, stateless.name(), false, scopeIsPresent);
            modified = true;
        }
        if ((stateful = this.findAnnotation(annotatedType.getJavaClass(), Stateful.class)) != null) {
            this.processClass(builder, stateful.name(), false, scopeIsPresent);
            modified = true;
        }
        try {
            Singleton singleton = this.findAnnotation(annotatedType.getJavaClass(), Singleton.class);
            if (singleton != null) {
                this.processClass(builder, singleton.name(), true, scopeIsPresent);
                modified = true;
                if (annotatedType.getAnnotation(Startup.class) != null) {
                    this.startupSingletons.add(annotatedType.getJavaClass());
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            EJB ejb = (EJB)method.getAnnotation(EJB.class);
            if (ejb == null) continue;
            builder.removeFromMethod(method, EJB.class);
            modified = true;
            if (!this.beanNameOrName(ejb).isEmpty()) {
                builder.addToMethod(method, (Annotation)new EjbName.EjbNameLiteral(this.beanNameOrName(ejb)));
                continue;
            }
            builder.addToMethod(method, (Annotation)DefaultLiteral.INSTANCE);
        }
        for (AnnotatedField field : annotatedType.getFields()) {
            Resource resource;
            boolean addInject = false;
            Produces produces = (Produces)field.getAnnotation(Produces.class);
            EJB ejb = (EJB)field.getAnnotation(EJB.class);
            if (ejb != null) {
                modified = true;
                addInject = true;
                if (field.getJavaMember().getType().equals(annotatedType.getJavaClass())) {
                    this.logger.error("Self injection of EJB Type {} in field {} of Class {} can't get simulated by ejb-cdi-unit", new Object[]{field.getJavaMember().getType().getName(), field.getJavaMember().getName(), field.getJavaMember().getDeclaringClass().getName()});
                }
                builder.removeFromField(field, EJB.class);
                if (!this.beanNameOrName(ejb).isEmpty()) {
                    builder.addToField(field, (Annotation)new EjbName.EjbNameLiteral(this.beanNameOrName(ejb)));
                } else {
                    builder.addToField(field, (Annotation)DefaultLiteral.INSTANCE);
                }
            }
            if ((resource = (Resource)field.getAnnotation(Resource.class)) != null) {
                addInject = true;
            }
            if (field.getAnnotation(PersistenceContext.class) != null) {
                addInject = true;
                builder.removeFromField(field, PersistenceContext.class);
            }
            if (!addInject) continue;
            modified = true;
            builder.addToField(field, (Annotation)new AnnotationLiteral<Inject>(){
                private static final long serialVersionUID = 1L;
            });
            if (produces != null) {
                builder.removeFromField(field, Produces.class);
            }
            if (!field.getBaseType().equals(String.class)) continue;
            builder.addToField(field, (Annotation)new ResourceQualifier.ResourceQualifierLiteral(resource.name(), resource.lookup(), resource.mappedName()){
                private static final long serialVersionUID = 1L;
            });
        }
        if (modified) {
            pat.setAnnotatedType(builder.create());
        }
    }

    public <X> void processInjectionTarget(@Observes ProcessAnnotatedType<X> pat) {
        if (this.isAnnotationPresent(pat, Stateless.class) || this.isAnnotationPresent(pat, Stateful.class) || this.isAnnotationPresent(pat, Singleton.class) || this.isAnnotationPresent(pat, MessageDriven.class)) {
            this.createEJBWrapper(pat, pat.getAnnotatedType());
        } else if (this.possiblyAsynchronous(pat.getAnnotatedType())) {
            this.logger.error("Non Ejb with Asynchronous-Annotation {}", pat);
        }
    }

    public <T> void initializeSelfInit(@Observes ProcessInjectionTarget<T> pit) {
        boolean needToWrap = false;
        for (AnnotatedField f : pit.getAnnotatedType().getFields()) {
            if (!f.getJavaMember().getType().equals(pit.getAnnotatedType().getJavaClass())) continue;
            needToWrap = true;
            break;
        }
        if (needToWrap) {
            final InjectionTarget it = pit.getInjectionTarget();
            final Set annotatedTypeFields = pit.getAnnotatedType().getFields();
            final Class annotatedTypeJavaClass = pit.getAnnotatedType().getJavaClass();
            InjectionTarget wrapped = new InjectionTarget<T>(){

                public void inject(T instance, CreationalContext<T> ctx) {
                    HashMap orgValues = this.fetchOriginalValuesOfSelfFields(instance);
                    it.inject(instance, ctx);
                    this.wrapDifferingValuesOfSelfFields(instance, orgValues);
                }

                public void postConstruct(T instance) {
                    it.postConstruct(instance);
                }

                public void preDestroy(T instance) {
                    it.dispose(instance);
                }

                public void dispose(T instance) {
                    it.dispose(instance);
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return it.getInjectionPoints();
                }

                public T produce(CreationalContext<T> ctx) {
                    return it.produce(ctx);
                }

                private void wrapDifferingValuesOfSelfFields(T instance, HashMap<AnnotatedField<? super T>, Object> orgValues) {
                    for (AnnotatedField f : annotatedTypeFields) {
                        if (!f.getJavaMember().getType().equals(annotatedTypeJavaClass)) continue;
                        try {
                            Field javaMember = f.getJavaMember();
                            javaMember.setAccessible(true);
                            final Object currentInstance = javaMember.get(instance);
                            if (currentInstance == null || currentInstance == orgValues.get(f)) continue;
                            Enhancer enhancer = new Enhancer();
                            enhancer.setSuperclass(currentInstance.getClass());
                            enhancer.setCallback((Callback)new InvocationHandler(){

                                public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                                    SessionContextSimulation.startInterceptionDecorationContext();
                                    try {
                                        Object object = method.invoke(currentInstance, objects);
                                        return object;
                                    }
                                    catch (Throwable thw) {
                                        if (thw instanceof InvocationTargetException) {
                                            throw thw.getCause();
                                        }
                                        throw thw;
                                    }
                                    finally {
                                        InterceptionDecorationContext.endInterceptorContext();
                                    }
                                }
                            });
                            javaMember.setAccessible(true);
                            javaMember.set(instance, enhancer.create());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                private HashMap<AnnotatedField<? super T>, Object> fetchOriginalValuesOfSelfFields(T instance) {
                    HashMap orgValues = new HashMap();
                    for (AnnotatedField f : annotatedTypeFields) {
                        if (!f.getJavaMember().getType().equals(annotatedTypeJavaClass)) continue;
                        Field javaMember = f.getJavaMember();
                        javaMember.setAccessible(true);
                        try {
                            orgValues.put(f, javaMember.get(instance));
                        }
                        catch (IllegalAccessException e) {
                            new RuntimeException(e);
                        }
                    }
                    return orgValues;
                }
            };
            pit.setInjectionTarget(wrapped);
        }
    }

    private <X> boolean possiblyAsynchronous(AnnotatedType<X> at) {
        boolean isTimer = false;
        boolean isAsynch = false;
        if (at.isAnnotationPresent(Asynchronous.class)) {
            return true;
        }
        for (AnnotatedMethod m : at.getMethods()) {
            if (!isTimer && (m.isAnnotationPresent(Timeout.class) || m.isAnnotationPresent(Schedule.class) || m.isAnnotationPresent(Schedules.class))) {
                this.timerClasses.add(m.getJavaMember().getDeclaringClass());
                isTimer = true;
            }
            if (isAsynch || !m.isAnnotationPresent(Asynchronous.class)) continue;
            isAsynch = true;
        }
        return isAsynch;
    }

    private <X> void createEJBWrapper(ProcessAnnotatedType<X> pat, AnnotatedType<X> at) {
        EjbAsynchronous ejbAsynchronous = (EjbAsynchronous)AnnotationInstanceProvider.of(EjbAsynchronous.class);
        EjbTransactional transactionalAnnotation = (EjbTransactional)AnnotationInstanceProvider.of(EjbTransactional.class);
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(at);
        builder.addToClass((Annotation)transactionalAnnotation);
        if (this.possiblyAsynchronous(at)) {
            builder.addToClass((Annotation)ejbAsynchronous);
        }
        pat.setAnnotatedType(builder.create());
    }

    void processManagedBean(@Observes ProcessManagedBean<?> event) {
        Bean bean = event.getBean();
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            StringBuilder sb = new StringBuilder();
            sb.append("  Found injection point ");
            sb.append(injectionPoint.getType());
            if (injectionPoint.getMember() != null && injectionPoint.getMember().getName() != null) {
                sb.append(": ");
                sb.append(injectionPoint.getMember().getName());
            }
            for (Annotation annotation : injectionPoint.getQualifiers()) {
                sb.append(" ");
                sb.append(annotation);
            }
            this.logger.trace(sb.toString());
        }
    }
}

