/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import org.jglue.cdiunit.ProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerConfigExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(ProducerConfigExtension.class);
    private final Method testMethod;

    public ProducerConfigExtension() {
        this(null);
    }

    public ProducerConfigExtension(Method testMethod) {
        this.testMethod = testMethod;
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) throws Exception {
        HashMap<Class<? extends Annotation>, Annotation> values = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Class<?> declaringClass = this.testMethod.getDeclaringClass(); declaringClass != null && !declaringClass.equals(Object.class); declaringClass = declaringClass.getEnclosingClass()) {
            ProducerConfigExtension.addConfigValues(values, declaringClass.getAnnotations());
        }
        ProducerConfigExtension.addConfigValues(values, this.testMethod.getAnnotations());
        for (final Annotation annotation : values.values()) {
            log.debug("Defining bean: value={} class={} ", (Object)annotation, (Object)annotation.getClass().getName());
            AnnotatedType at = bm.createAnnotatedType(annotation.getClass());
            final InjectionTarget it = bm.createInjectionTarget(at);
            abd.addBean((Bean)new Bean<Annotation>(){

                public Class<?> getBeanClass() {
                    return annotation.annotationType();
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return it.getInjectionPoints();
                }

                public String getName() {
                    return null;
                }

                public Set<Annotation> getQualifiers() {
                    HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                    qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                    qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                    return qualifiers;
                }

                public Class<? extends Annotation> getScope() {
                    return Dependent.class;
                }

                public Set<Class<? extends Annotation>> getStereotypes() {
                    return Collections.emptySet();
                }

                public Set<Type> getTypes() {
                    HashSet<Type> types = new HashSet<Type>();
                    types.add(annotation.annotationType());
                    types.add((Type)((Object)Annotation.class));
                    types.add((Type)((Object)Object.class));
                    return types;
                }

                public boolean isAlternative() {
                    return false;
                }

                public boolean isNullable() {
                    return false;
                }

                public Annotation create(CreationalContext<Annotation> ctx) {
                    return annotation;
                }

                public void destroy(Annotation instance, CreationalContext<Annotation> ctx) {
                    ctx.release();
                }
            });
        }
    }

    private static void addConfigValues(Map<Class<? extends Annotation>, Annotation> values, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ProducerConfig.class)) continue;
            if (!Modifier.isPublic(annotation.annotationType().getModifiers())) {
                throw new RuntimeException("ProducerConfig annotation classes must be public");
            }
            values.put(annotation.annotationType(), annotation);
        }
    }
}

