/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.internal;

import com.oneandone.ejbcdiunit.internal.ApplicationExceptionDescription;
import com.oneandone.ejbcdiunit.internal.EjbInformationBean;
import com.oneandone.ejbcdiunit.internal.EjbTransactional;
import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.ejb.ApplicationException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Interceptor
@EjbTransactional
public class TransactionalInterceptor {
    private final Logger logger = LoggerFactory.getLogger(TransactionalInterceptor.class);
    private SimulatedTransactionManager transactionManager = new SimulatedTransactionManager();
    static ThreadLocal<TransactionAttributeType> lastTransactionAttributeType = new ThreadLocal();
    static ThreadLocal<Integer> level = new ThreadLocal();
    @Inject
    private EjbInformationBean ejbInformationBean;

    int getLevel() {
        Integer actLevel = level.get();
        if (actLevel == null) {
            level.set(0);
            actLevel = 0;
        }
        return actLevel;
    }

    void incLevel() {
        level.set(this.getLevel() + 1);
    }

    void decLevel() {
        level.set(this.getLevel() - 1);
    }

    private ApplicationException findApplicationException(Throwable ex) {
        Class<?> tmp = ex.getClass();
        ApplicationException applicationException = null;
        while (!tmp.equals(Throwable.class)) {
            applicationException = tmp.getAnnotation(ApplicationException.class);
            if (applicationException == null) {
                List<ApplicationExceptionDescription> ejbJarDescriptions = this.ejbInformationBean.getApplicationExceptionDescriptions();
                for (final ApplicationExceptionDescription aed : ejbJarDescriptions) {
                    if (!aed.getClassName().equals(tmp.getName())) continue;
                    applicationException = new ApplicationException(){

                        public Class<? extends Annotation> annotationType() {
                            return ApplicationException.class;
                        }

                        public boolean inherited() {
                            return aed.isInherited();
                        }

                        public boolean rollback() {
                            return aed.isRollback();
                        }
                    };
                    break;
                }
            }
            if (applicationException != null) break;
            tmp = tmp.getSuperclass();
        }
        if (applicationException != null && (tmp.equals(ex.getClass()) || applicationException.inherited())) {
            return applicationException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @AroundInvoke
    public Object manageTransaction(InvocationContext ctx) throws Exception {
        block22: {
            Object transactionMethod;
            TransactionAttributeType toPush;
            boolean beanManaged;
            if (!this.transactionManager.hasActiveTransactionInterceptor()) break block22;
            Class<?> declaringClass = ctx.getMethod().getDeclaringClass();
            Class<?> targetClass = this.getTargetClass(ctx);
            boolean bl = beanManaged = this.isBeanManaged(declaringClass) || this.isBeanManaged(targetClass);
            if (this.isNotEjbClass(declaringClass) && this.isNotEjbClass(targetClass) && ctx.getMethod().getAnnotation(EJB.class) == null) {
                return ctx.proceed();
            }
            this.incLevel();
            TransactionAttributeType savedLastTransactionAttributeType = lastTransactionAttributeType.get();
            if (beanManaged) {
                toPush = TransactionAttributeType.NOT_SUPPORTED;
            } else {
                TransactionAttribute transaction = this.findAnnotation(declaringClass, TransactionAttribute.class);
                transactionMethod = ctx.getMethod().getAnnotation(TransactionAttribute.class);
                toPush = transactionMethod != null ? transactionMethod.value() : (transaction != null ? transaction.value() : TransactionAttributeType.REQUIRED);
            }
            this.transactionManager.push(toPush);
            lastTransactionAttributeType.set(toPush);
            boolean passThroughRollbackException = true;
            this.logger.debug("Thread {} L{} changing  from {} to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, toPush, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
            transactionMethod = ctx.proceed();
            this.logger.debug("Thread {} L{} finally   in {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
            try {
                this.transactionManager.pop();
            }
            catch (RollbackException rbe) {
                block19: {
                    try {
                        if (!passThroughRollbackException) break block19;
                        throw rbe;
                    }
                    catch (Throwable throwable) {
                        this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                        throw throwable;
                    }
                }
                this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
            }
            this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
            lastTransactionAttributeType.set(savedLastTransactionAttributeType);
            this.decLevel();
            return transactionMethod;
            catch (Throwable ex) {
                try {
                    boolean doRollback;
                    this.logger.debug("Thread {} L{} Exception {} in {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), ex.getClass().getSimpleName(), toPush, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                    if (beanManaged) {
                        if (ex instanceof RuntimeException) {
                            throw new EJBException((Exception)((RuntimeException)ex));
                        }
                        throw ex;
                    }
                    ApplicationException applicationException = this.findApplicationException(ex);
                    boolean bl2 = doRollback = applicationException != null ? applicationException.rollback() : ex instanceof RuntimeException;
                    if (doRollback) {
                        passThroughRollbackException = false;
                        this.transactionManager.rollback(false);
                        this.transactionManager.setRollbackOnly(false);
                    }
                    if (applicationException == null && ex instanceof RuntimeException) {
                        throw new EJBException((Exception)((RuntimeException)ex));
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.logger.debug("Thread {} L{} finally   in {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                    try {
                        this.transactionManager.pop();
                    }
                    catch (RollbackException rbe) {
                        block20: {
                            try {
                                if (!passThroughRollbackException) break block20;
                                throw rbe;
                            }
                            catch (Throwable throwable2) {
                                this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                                throw throwable2;
                            }
                        }
                        this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                    }
                    this.logger.debug("Thread {} L{} done      {} back to {} xid: {} in {}.{}", new Object[]{Thread.currentThread().getId(), this.getLevel(), toPush, savedLastTransactionAttributeType == null ? "undefined" : savedLastTransactionAttributeType, MDC.get((String)"XID"), declaringClass.getSimpleName(), ctx.getMethod().getName()});
                    lastTransactionAttributeType.set(savedLastTransactionAttributeType);
                    this.decLevel();
                    throw throwable;
                }
            }
        }
        return ctx.proceed();
    }

    private Class<?> getTargetClass(InvocationContext ctx) {
        Object target = ctx.getTarget();
        if (target == null) {
            return null;
        }
        Class<?> res = target.getClass();
        if (res.getName().endsWith("WeldSubclass")) {
            return res.getSuperclass();
        }
        return res;
    }

    <T extends Annotation> T findAnnotation(Class<?> declaringClass, Class<T> annotationType) {
        if (declaringClass == null || declaringClass.equals(Object.class)) {
            return null;
        }
        T annotation = declaringClass.getAnnotation(annotationType);
        if (annotation == null) {
            return this.findAnnotation(declaringClass.getSuperclass(), annotationType);
        }
        return annotation;
    }

    private boolean isBeanManaged(Class<?> declaringClass) {
        TransactionManagement annotation = this.findAnnotation(declaringClass, TransactionManagement.class);
        if (annotation == null) {
            return false;
        }
        return annotation.value() == TransactionManagementType.BEAN;
    }

    private boolean isNotEjbClass(Class<?> declaringClass) {
        if (declaringClass.equals(Object.class)) {
            return true;
        }
        TransactionAttribute tmAnnotation = this.findAnnotation(declaringClass, TransactionAttribute.class);
        if (tmAnnotation != null) {
            return false;
        }
        boolean result = declaringClass != null && declaringClass.getAnnotation(TransactionManagement.class) == null && declaringClass.getAnnotation(MessageDriven.class) == null && declaringClass.getAnnotation(Stateless.class) == null && declaringClass.getAnnotation(Stateful.class) == null && declaringClass.getAnnotation(Singleton.class) == null;
        return result;
    }
}

