/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.jms;

import com.mockrunner.mock.jms.MockQueue;
import com.oneandone.ejbcdiunit.AsynchronousManager;
import com.oneandone.ejbcdiunit.internal.AsynchronousMessageListenerProxy;
import com.oneandone.ejbcdiunit.jms.JmsSingletons;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JmsMocksFactory {
    @Inject
    JmsSingletons jmsSingletons;
    private AtomicBoolean initedMessageListeners = new AtomicBoolean(false);
    private ArrayList<MessageConsumer> messageConsumers = new ArrayList();
    @Inject
    Instance<MessageListener> messageListeners;
    @Inject
    AsynchronousManager asynchronousManager;
    private Logger logger = LoggerFactory.getLogger((String)"JmsMdbConnector");
    private static ThreadLocal<Boolean> postConstructing = new ThreadLocal();

    @PostConstruct
    public void postConstruct() {
        this.logger.info("JmsMdbConnector.postConstruct start");
        if (postConstructing.get() != null && postConstructing.get().booleanValue()) {
            this.logger.error("JmsMdbConnector already postConstructing");
        } else {
            try {
                postConstructing.set(true);
                this.initMessageListeners();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
            finally {
                postConstructing.set(false);
            }
        }
        this.logger.info("JmsMdbConnector.postConstruct done");
    }

    @PreDestroy
    public void predestroy() {
        for (MessageConsumer messageConsumer : this.messageConsumers) {
            try {
                messageConsumer.close();
            }
            catch (JMSException jMSException) {}
        }
        this.jmsSingletons.destroy();
    }

    private synchronized void initMessageListeners() throws JMSException {
        if (!this.initedMessageListeners.get()) {
            this.logger.info("JmsMdbConnector.postConstruct initMessageListeners start");
            for (MessageListener messageListener : this.messageListeners) {
                this.logger.info("JmsMdbConnector initMessageListeners {}", (Object)messageListener);
                Class<?> clazz = messageListener.getClass();
                if (!clazz.isAnnotationPresent(MessageDriven.class)) {
                    clazz = clazz.getSuperclass();
                }
                MessageDriven messageDriven = clazz.getAnnotation(MessageDriven.class);
                String destinationType = null;
                Integer acknowledgeMode = null;
                String destination = null;
                String messageSelector = null;
                for (ActivationConfigProperty p : messageDriven.activationConfig()) {
                    if ("destinationType".equals(p.propertyName())) {
                        destinationType = p.propertyValue();
                        continue;
                    }
                    if ("destination".equals(p.propertyName())) {
                        destination = this.calculateCommonName(p.propertyValue());
                        continue;
                    }
                    if ("acknowledgeMode".equals(p.propertyName())) {
                        acknowledgeMode = "Auto_acknowledge".equals(p.propertyValue()) ? 1 : 3;
                        continue;
                    }
                    if ("messageSelector".equals(p.propertyName())) {
                        messageSelector = p.propertyValue();
                        continue;
                    }
                    if (!"destinationType".equals(p.propertyName())) continue;
                    destinationType = p.propertyValue();
                }
                if (destinationType == null || destination == null) continue;
                this.logger.info("JmsMdbConnector initMessageListeners destination: {}", destination);
                Connection connection = JmsSingletons.mdbConnection.get();
                Session session = acknowledgeMode == null ? connection.createSession(false, 1) : connection.createSession(false, acknowledgeMode.intValue());
                MockQueue dest = null;
                if ("javax.jms.Queue".equals(destinationType)) {
                    dest = this.jmsSingletons.getDestinationManager().createQueue(destination);
                } else if ("javax.jms.Topic".equals(destinationType)) {
                    dest = this.jmsSingletons.getDestinationManager().createTopic(destination);
                }
                MessageConsumer messageConsumer = messageSelector == null ? session.createConsumer((Destination)dest) : session.createConsumer((Destination)dest, messageSelector);
                this.messageConsumers.add(messageConsumer);
                messageConsumer.setMessageListener((MessageListener)new AsynchronousMessageListenerProxy(messageListener, this.asynchronousManager));
            }
            this.logger.info("JmsMdbConnector.postConstruct initMessageListeners done");
        }
    }

    private String getResourceName(InjectionPoint ip) {
        Resource resourceAnnotation = (Resource)ip.getAnnotated().getAnnotation(Resource.class);
        String name = resourceAnnotation.mappedName();
        if (name.trim().isEmpty() && (name = resourceAnnotation.lookup()).trim().isEmpty()) {
            name = "dummyName";
        }
        return name;
    }

    private String calculateCommonName(String name) {
        int lastSlashIndex = name.lastIndexOf("/");
        if (lastSlashIndex < 0) {
            return name;
        }
        return name.substring(lastSlashIndex + 1);
    }

    @Produces
    public Queue createQueue(InjectionPoint ip) {
        String name = this.getResourceName(ip);
        return this.jmsSingletons.getDestinationManager().createQueue(this.calculateCommonName(name));
    }

    @Produces
    public Topic createTopic(InjectionPoint ip) {
        String name = this.getResourceName(ip);
        return this.jmsSingletons.getDestinationManager().createTopic(this.calculateCommonName(name));
    }

    @Produces
    @ApplicationScoped
    public ConnectionFactory getConnectionFactory() throws Exception {
        return this.jmsSingletons.getConnectionFactory();
    }
}

