/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.mock.jms.MockConnectionFactory;
import com.oneandone.ejbcdiunit.jms.MockConnectionFactoryExt;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSingletons {
    static AtomicReference<DestinationManager> destinationManagerAtomicReference = new AtomicReference();
    static AtomicReference<MockConnectionFactory> connectionFactoryAtomicReference = new AtomicReference();
    static AtomicReference<Connection> mdbConnection = new AtomicReference();
    Logger logger = LoggerFactory.getLogger((String)"JmsFactory");

    JmsSingletons() {
        try {
            this.getConnectionFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (connectionFactoryAtomicReference.get() != null) {
            connectionFactoryAtomicReference.get().clearConnections();
            connectionFactoryAtomicReference = new AtomicReference();
        }
        destinationManagerAtomicReference = new AtomicReference();
        mdbConnection = new AtomicReference();
    }

    DestinationManager getDestinationManager() {
        if (destinationManagerAtomicReference.get() == null) {
            DestinationManager tmp = new DestinationManager();
            destinationManagerAtomicReference.compareAndSet(null, tmp);
        }
        return destinationManagerAtomicReference.get();
    }

    public ConnectionFactory getConnectionFactory() throws Exception {
        if (connectionFactoryAtomicReference.get() == null) {
            ConfigurationManager configurationManager = new ConfigurationManager();
            configurationManager.setDoCloneOnSend(true);
            MockConnectionFactory tmp = new MockConnectionFactory(this.getDestinationManager(), configurationManager);
            if (connectionFactoryAtomicReference.compareAndSet(null, tmp)) {
                mdbConnection.set(tmp.createConnection());
            }
        }
        return new MockConnectionFactoryExt(connectionFactoryAtomicReference.get());
    }
}

