/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.persistence.ConnectionDelegate;
import com.oneandone.ejbcdiunit.persistence.PersistenceFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.TransactionRequiredException;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;

public class DataSourceDelegate
implements DataSource {
    private final PersistenceFactory entityManagerStore;
    private final DataSource dataSource;

    DataSourceDelegate(PersistenceFactory entityManagerStore) {
        this.entityManagerStore = entityManagerStore;
        this.dataSource = entityManagerStore.createDataSource();
    }

    private DataSource getDatasource() {
        return this.dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            EntityManager tmp = this.entityManagerStore.getTransactional(false);
            Session session = (Session)tmp.unwrap(Session.class);
            SessionImplementor sessionImplementor = (SessionImplementor)session;
            return new ConnectionDelegate(sessionImplementor);
        }
        catch (TransactionRequiredException e) {
            throw new RuntimeException("not expected exception: ", e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDatasource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDatasource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDatasource().setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDatasource().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDatasource().setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDatasource().getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDatasource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDatasource().isWrapperFor(iface);
    }
}

