/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.persistence.PersistenceFactory;
import com.oneandone.ejbcdiunit.persistence.SimulatedEntityTransaction;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;

class EntityManagerDelegate
implements EntityManager {
    private final PersistenceFactory entityManagerStore;

    EntityManagerDelegate(PersistenceFactory entityManagerStore) {
        this.entityManagerStore = entityManagerStore;
    }

    private EntityManager getEmbeddedEntityManager() {
        try {
            return this.entityManagerStore.getTransactional(false);
        }
        catch (TransactionRequiredException e) {
            throw new RuntimeException("not expected exception: ", e);
        }
    }

    private EntityManager getEmbeddedEntityManager(boolean expectTransaction) {
        return this.entityManagerStore.getTransactional(expectTransaction);
    }

    public void persist(Object entity) {
        this.getEmbeddedEntityManager(true).persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.getEmbeddedEntityManager(true).merge(entity);
    }

    public void remove(Object entity) {
        this.getEmbeddedEntityManager(true).remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEmbeddedEntityManager().find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.getEmbeddedEntityManager().find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.getEmbeddedEntityManager().find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.getEmbeddedEntityManager().find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEmbeddedEntityManager().getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.getEmbeddedEntityManager(true).flush();
    }

    public FlushModeType getFlushMode() {
        return this.getEmbeddedEntityManager().getFlushMode();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEmbeddedEntityManager().setFlushMode(flushMode);
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getEmbeddedEntityManager(true).lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEmbeddedEntityManager(true).lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.getEmbeddedEntityManager(true).refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.getEmbeddedEntityManager(true).refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.getEmbeddedEntityManager(true).refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEmbeddedEntityManager(true).refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.getEmbeddedEntityManager().clear();
    }

    public void detach(Object entity) {
        this.getEmbeddedEntityManager().detach(entity);
    }

    public boolean contains(Object entity) {
        return this.getEmbeddedEntityManager().contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.getEmbeddedEntityManager(true).getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.getEmbeddedEntityManager().setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.getEmbeddedEntityManager().getProperties();
    }

    public Query createQuery(String qlString) {
        return this.getEmbeddedEntityManager().createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.getEmbeddedEntityManager().createQuery(criteriaQuery);
    }

    public Query createQuery(CriteriaUpdate criteriaUpdate) {
        return this.getEmbeddedEntityManager().createQuery(criteriaUpdate);
    }

    public Query createQuery(CriteriaDelete criteriaDelete) {
        return this.getEmbeddedEntityManager().createQuery(criteriaDelete);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.getEmbeddedEntityManager().createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        return this.getEmbeddedEntityManager().createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.getEmbeddedEntityManager().createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.getEmbeddedEntityManager().createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.getEmbeddedEntityManager().createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.getEmbeddedEntityManager().createNativeQuery(sqlString, resultSetMapping);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.getEmbeddedEntityManager().createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.getEmbeddedEntityManager().createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class[] resultClasses) {
        return this.getEmbeddedEntityManager().createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.getEmbeddedEntityManager().createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public void joinTransaction() {
        this.getEmbeddedEntityManager().joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.getEmbeddedEntityManager().isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEmbeddedEntityManager().unwrap(cls);
    }

    public Object getDelegate() {
        return this.getEmbeddedEntityManager().getDelegate();
    }

    public void close() {
        this.getEmbeddedEntityManager().close();
    }

    public boolean isOpen() {
        return this.getEmbeddedEntityManager().isOpen();
    }

    public EntityTransaction getTransaction() {
        return new SimulatedEntityTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEmbeddedEntityManager().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEmbeddedEntityManager().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEmbeddedEntityManager().getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.getEmbeddedEntityManager().createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.getEmbeddedEntityManager().createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.getEmbeddedEntityManager().getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.getEmbeddedEntityManager().getEntityGraphs(entityClass);
    }
}

