/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.SupportEjbExtended;
import com.oneandone.ejbcdiunit.persistence.DataSourceDelegate;
import com.oneandone.ejbcdiunit.persistence.EntityManagerDelegate;
import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import com.oneandone.ejbcdiunit.persistence.TestClosure;
import com.oneandone.ejbcdiunit.persistence.TestTransaction;
import com.oneandone.ejbcdiunit.persistence.TestTransactionException;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TransactionRequiredException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportEjbExtended
@ApplicationScoped
public abstract class PersistenceFactory {
    private static final HashSet<String> PERSISTENCE_UNIT_NAMES = new HashSet();
    private final Logger logger = LoggerFactory.getLogger(PersistenceFactory.class);
    private final ThreadLocal<Stack<EntityManager>> emStackThreadLocal = new ThreadLocal();
    private EntityManagerFactory emf = null;
    private SimulatedTransactionManager transactionManager = new SimulatedTransactionManager();
    private ConcurrentLinkedQueue<Stack<EntityManager>> threadlocalStacks = new ConcurrentLinkedQueue();

    public static void clearPersistenceUnitNames() {
        PERSISTENCE_UNIT_NAMES.clear();
    }

    protected abstract String getPersistenceUnitName();

    private ThreadLocal<Stack<EntityManager>> getEmStackThreadLocal() {
        return this.emStackThreadLocal;
    }

    private EntityManagerFactory getEmf() {
        return this.emf;
    }

    private void setEmf(EntityManagerFactory emfP) {
        this.emf = emfP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void construct() {
        this.logger.info("creating persistence factory {}", (Object)this.getPersistenceUnitName());
        HashSet<String> hashSet = PERSISTENCE_UNIT_NAMES;
        synchronized (hashSet) {
            if (PERSISTENCE_UNIT_NAMES.contains(this.getPersistenceUnitName())) {
                throw new RuntimeException("Repeated construction of currently existing PersistenceFactory for " + this.getPersistenceUnitName());
            }
            this.setEmf(this.createEntityManagerFactory());
            PERSISTENCE_UNIT_NAMES.add(this.getPersistenceUnitName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroy() {
        this.logger.info("destroying persistence factory {}", (Object)this.getPersistenceUnitName());
        HashSet<String> hashSet = PERSISTENCE_UNIT_NAMES;
        synchronized (hashSet) {
            if (!PERSISTENCE_UNIT_NAMES.contains(this.getPersistenceUnitName())) {
                throw new RuntimeException("Expected PersistenceFactory for " + this.getPersistenceUnitName());
            }
            for (Stack<EntityManager> stack : this.threadlocalStacks) {
                for (EntityManager em : stack) {
                    if (em.getTransaction().isActive()) {
                        try {
                            em.getTransaction().rollback();
                        }
                        catch (Throwable thw) {
                            this.logger.error("Throwable during closing of pending transaction", thw);
                        }
                    }
                    em.close();
                }
                stack.clear();
            }
            if (this.getEmf() != null && this.getEmf().isOpen()) {
                this.getEmf().close();
            }
            PERSISTENCE_UNIT_NAMES.remove(this.getPersistenceUnitName());
        }
    }

    EntityManager getTransactional(boolean expectTransaction) {
        try {
            if (expectTransaction && this.transactionManager.getStatus() == 6) {
                throw new TransactionRequiredException("Expected, but no transaction during Ejb-Simulation");
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        this.transactionManager.takePart(this);
        EntityManager result = this.get();
        if (expectTransaction && !result.getTransaction().isActive()) {
            throw new TransactionRequiredException("Ejb-Simulation");
        }
        return result;
    }

    EntityManager get() {
        Stack<EntityManager> entityManagerStack = this.getEmStackThreadLocal().get();
        if (entityManagerStack == null || entityManagerStack.isEmpty()) {
            return this.getEntityManager();
        }
        return this.getEmStackThreadLocal().get().peek();
    }

    EntityManager getEntityManager() {
        Stack<EntityManager> entityManagerStack = this.getEmStackThreadLocal().get();
        if (entityManagerStack == null || entityManagerStack.isEmpty()) {
            this.createAndRegister();
        }
        return this.getEmStackThreadLocal().get().peek();
    }

    void createAndRegister() {
        this.logger.trace("Creating and registering an entity manager for " + Thread.currentThread().getName());
        Stack<Object> entityManagerStack = this.getEmStackThreadLocal().get();
        if (entityManagerStack == null) {
            entityManagerStack = new Stack();
            this.getEmStackThreadLocal().set(entityManagerStack);
            this.threadlocalStacks.add(entityManagerStack);
        }
        EntityManager entityManager = this.getEmf().createEntityManager();
        entityManagerStack.push(entityManager);
    }

    void unRegister() {
        this.logger.trace("UnRegistering an entity manager");
        Stack<EntityManager> entityManagerStack = this.getEmStackThreadLocal().get();
        if (entityManagerStack == null || entityManagerStack.isEmpty()) {
            throw new IllegalStateException("Removing of entity manager failed. Your entity manager was not found.");
        }
        EntityManager entityManager = entityManagerStack.pop();
        if (entityManager.getTransaction().isActive()) {
            throw new IllegalStateException("Popping with active transaction");
        }
        entityManager.close();
    }

    public TestTransaction transaction(TransactionAttributeType transactionAttribute) {
        return new TestTransaction(transactionAttribute);
    }

    public void transaction(TransactionAttributeType transactionAttribute, TestClosure runnable) {
        try (TestTransaction tra = this.transaction(transactionAttribute);){
            try {
                runnable.execute();
            }
            catch (Throwable e) {
                throw new TestTransactionException(e);
            }
        }
        catch (Exception e) {
            throw new TestTransactionException(e);
        }
    }

    public EntityManager produceEntityManager() {
        return new EntityManagerDelegate(this);
    }

    public DataSource createDataSource() {
        Map props = this.emf.getProperties();
        DataSource emfDatasource = (DataSource)props.get("hibernate.connection.datasource");
        if (emfDatasource != null) {
            return emfDatasource;
        }
        BasicDataSource newDataSource = new BasicDataSource();
        newDataSource.setDriverClassName((String)props.get("javax.persistence.jdbc.driver"));
        newDataSource.setUrl((String)props.get("javax.persistence.jdbc.url"));
        return newDataSource;
    }

    public DataSource produceDataSource() {
        return new DataSourceDelegate(this);
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceFactory that = (PersistenceFactory)obj;
        return this.getPersistenceUnitName() != null ? this.getPersistenceUnitName().equals(that.getPersistenceUnitName()) : that.getPersistenceUnitName() == null;
    }

    public int hashCode() {
        return this.getPersistenceUnitName() != null ? this.getPersistenceUnitName().hashCode() : 0;
    }
}

