/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.persistence.SimulatedTransactionManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.transaction.SystemException;

class SimulatedEntityTransaction
implements EntityTransaction {
    SimulatedEntityTransaction() {
    }

    public void begin() {
        new SimulatedTransactionManager().push();
    }

    public void commit() throws IllegalStateException, RollbackException {
        try {
            new SimulatedTransactionManager().commit(true);
        }
        catch (javax.transaction.RollbackException e) {
            throw new RollbackException((Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void rollback() throws IllegalStateException, PersistenceException {
        try {
            new SimulatedTransactionManager().rollback(true);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        try {
            new SimulatedTransactionManager().setRollbackOnly(true);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        try {
            return new SimulatedTransactionManager().getRollbackOnly(true);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public boolean isActive() {
        try {
            int status = new SimulatedTransactionManager().getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

