/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.persistence.PersistenceFactory;
import com.oneandone.ejbcdiunit.persistence.TestTransactionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionRolledbackLocalException;
import javax.persistence.TransactionRequiredException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;

public class SimulatedTransactionManager {
    private static AtomicBoolean activeTransactionInterceptor = new AtomicBoolean();
    private static ThreadLocal<ArrayList<ThreadLocalTransactionInformation>> transactionStack = new ThreadLocal();
    private static ThreadLocal<ArrayList<Synchronization>> synchronizations = new ThreadLocal();
    private static ConcurrentLinkedQueue<ArrayList<ThreadLocalTransactionInformation>> allStacks = new ConcurrentLinkedQueue();

    private static TestTransactionBase getTestTransactionBase(int i, PersistenceFactory persistenceFactory) {
        if (i < 0) {
            return null;
        }
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        for (TestTransactionBase testTransactionBase : stack.get((int)i).persistenceFactories) {
            if (!testTransactionBase.getPersistenceFactory().equals(persistenceFactory)) continue;
            return testTransactionBase;
        }
        return null;
    }

    public void registerSynchronisation(Synchronization synchronization) {
        ArrayList<Synchronization> synchs = this.initSynchronizations();
        synchs.add(synchronization);
    }

    public void synchBeforeCompletion() {
        if (synchronizations.get() != null) {
            for (Synchronization s : synchronizations.get()) {
                s.beforeCompletion();
            }
        }
    }

    public void synchAfterCompletion(int res) {
        if (synchronizations.get() != null) {
            for (Synchronization s : synchronizations.get()) {
                s.afterCompletion(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            for (ArrayList<ThreadLocalTransactionInformation> stack : allStacks) {
                if (stack == null) continue;
                try {
                    for (int i = stack.size() - 1; i >= 0; --i) {
                        for (TestTransactionBase ttb : stack.get((int)i).persistenceFactories) {
                            try {
                                ttb.close(true);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                finally {
                    stack.clear();
                }
            }
            PersistenceFactory.clearPersistenceUnitNames();
        }
        finally {
            this.activateTransactionInterceptor();
        }
    }

    public void deactivateTransactionInterceptor() {
        activeTransactionInterceptor.set(false);
    }

    public void activateTransactionInterceptor() {
        activeTransactionInterceptor.set(true);
    }

    public boolean hasActiveTransactionInterceptor() {
        return activeTransactionInterceptor.get();
    }

    public void push(TransactionAttributeType transactionAttributeType) {
        ArrayList<ThreadLocalTransactionInformation> stack = this.initStack();
        stack.add(new ThreadLocalTransactionInformation(transactionAttributeType));
    }

    private ArrayList<Synchronization> initSynchronizations() {
        ArrayList<Object> synchs = synchronizations.get();
        if (synchs == null) {
            synchs = new ArrayList();
            synchronizations.set(synchs);
        }
        return synchs;
    }

    private ArrayList<ThreadLocalTransactionInformation> initStack() {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        if (stack == null) {
            stack = new ArrayList();
            transactionStack.set(stack);
            allStacks.add(stack);
        }
        return stack;
    }

    public void push() {
        ArrayList<ThreadLocalTransactionInformation> stack = this.initStack();
        stack.add(new ThreadLocalTransactionInformation());
    }

    private int findTestTransactionBase(PersistenceFactory persistenceFactory) {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (SimulatedTransactionManager.getTestTransactionBase(i, persistenceFactory) == null) continue;
            return i;
        }
        return -1;
    }

    public void takePart(PersistenceFactory persistenceFactory) {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        if (stack == null || stack.isEmpty()) {
            this.push(TransactionAttributeType.NOT_SUPPORTED);
            transactionStack.get().get(0).setTestTransaction();
            stack = transactionStack.get();
        }
        if (stack.get(stack.size() - 1).isRolledBack()) {
            throw new TransactionRolledbackLocalException("Simulated Transaction Manager");
        }
        int pos = this.findTestTransactionBase(persistenceFactory);
        if (pos == stack.size() - 1) {
            return;
        }
        TestTransactionBase act = SimulatedTransactionManager.getTestTransactionBase(pos, persistenceFactory);
        for (int i = pos + 1; i < stack.size(); ++i) {
            ThreadLocalTransactionInformation threadLocalTransactionInformation = stack.get(i);
            TransactionAttributeType attribute = threadLocalTransactionInformation.transactionAttributeType;
            TestTransactionBase newTestTransactionBase = new TestTransactionBase(persistenceFactory, attribute, act);
            threadLocalTransactionInformation.persistenceFactories.add(newTestTransactionBase);
            act = newTestTransactionBase;
        }
    }

    public void rollback(Boolean expectUserTransaction) throws IllegalStateException, SecurityException, SystemException {
        this.synchBeforeCompletion();
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        this.handleUserTransactionOrNot(expectUserTransaction, stack);
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        if (expectUserTransaction == null || expectUserTransaction.booleanValue()) {
            stack.remove(stack.size() - 1);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TestTransactionBase testTransactionBase : element.persistenceFactories) {
            try {
                element.setRolledBack();
                testTransactionBase.rollback();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        try {
            this.handleExceptions(exceptions);
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        this.synchAfterCompletion(4);
    }

    public void commit(Boolean expectUserTransaction) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.synchBeforeCompletion();
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        this.handleUserTransactionOrNot(expectUserTransaction, stack);
        if (stack.get(stack.size() - 1).isRolledBack()) {
            this.rollback(true);
            throw new RollbackException("Can't commit because rolled back");
        }
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        boolean setRollbackOnly = element.getRollbackOnly();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TestTransactionBase testTransactionBase : element.persistenceFactories) {
            try {
                testTransactionBase.close(setRollbackOnly);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (element.isUserTransaction()) {
            stack.remove(stack.size() - 1);
        }
        if (setRollbackOnly && element.isUserTransaction()) {
            throw new RollbackException("Test Transaction fails.");
        }
        this.handleExceptions(exceptions);
        this.synchAfterCompletion(3);
    }

    private void handleUserTransactionOrNot(Boolean expectUserTransaction, ArrayList<ThreadLocalTransactionInformation> stack) throws IllegalStateException {
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException("No Transaction Context");
        }
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        if (expectUserTransaction != null && expectUserTransaction.booleanValue() != element.isUserTransaction()) {
            throw new IllegalStateException("Trying to setRollbackOnly in wrong transaction state");
        }
    }

    public void setRollbackOnly(Boolean expectUserTransaction) throws IllegalStateException {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        this.handleUserTransactionOrNot(expectUserTransaction, stack);
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        element.setRollbackOnly();
    }

    public boolean getRollbackOnly(Boolean expectUserTransaction) throws IllegalStateException {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        this.handleUserTransactionOrNot(expectUserTransaction, stack);
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        return element.getRollbackOnly();
    }

    private void handleExceptions(ArrayList<Exception> exceptions) throws RollbackException {
        if (exceptions.size() == 1) {
            Exception currentException = exceptions.get(0);
            if (currentException instanceof RollbackException) {
                throw (RollbackException)((Object)currentException);
            }
            if (currentException instanceof TransactionRequiredException) {
                throw (TransactionRequiredException)((Object)currentException);
            }
            throw new RuntimeException(currentException);
        }
        if (exceptions.size() > 1) {
            throw new RuntimeException("Combined Exceptions in multiple Transactions");
        }
    }

    public void pop() throws Exception {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        if (stack.size() > 0) {
            ThreadLocalTransactionInformation element = stack.remove(stack.size() - 1);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (TestTransactionBase testTransactionBase : element.persistenceFactories) {
                try {
                    testTransactionBase.close(element.getRollbackOnly() || element.isRolledBack());
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            this.handleExceptions(exceptions);
        }
    }

    public int getStatus() throws SystemException {
        ArrayList<ThreadLocalTransactionInformation> stack = transactionStack.get();
        if (stack == null || stack.isEmpty()) {
            return 6;
        }
        ThreadLocalTransactionInformation element = stack.get(stack.size() - 1);
        return element.getStatus();
    }

    static class ThreadLocalTransactionInformation {
        ThreadLocalTransactionInformation previous = this.calcPrevious();
        TransactionAttributeType transactionAttributeType;
        boolean rollbackOnly = false;
        boolean userTransaction = false;
        boolean testTransaction = false;
        List<TestTransactionBase> persistenceFactories = new ArrayList<TestTransactionBase>();
        private boolean rolledBack;

        ThreadLocalTransactionInformation(TransactionAttributeType transactionAttributeType) {
            this.transactionAttributeType = transactionAttributeType;
            this.userTransaction = false;
        }

        ThreadLocalTransactionInformation() {
            this.transactionAttributeType = TransactionAttributeType.REQUIRES_NEW;
            this.userTransaction = true;
        }

        public boolean isTestTransaction() {
            return this.testTransaction;
        }

        public void setTestTransaction() {
            this.testTransaction = true;
        }

        public ThreadLocalTransactionInformation getPrevious() {
            return this.previous;
        }

        private ThreadLocalTransactionInformation calcPrevious() {
            ArrayList stack = (ArrayList)transactionStack.get();
            if (!stack.isEmpty()) {
                return (ThreadLocalTransactionInformation)stack.get(stack.size() - 1);
            }
            return null;
        }

        void setRollbackOnly() {
            this.rollbackOnly = true;
            if (this.transactionAttributeType == TransactionAttributeType.REQUIRED && this.previous != null && (this.previous.transactionAttributeType == TransactionAttributeType.REQUIRED || this.previous.transactionAttributeType == TransactionAttributeType.REQUIRES_NEW)) {
                this.previous.setRollbackOnly();
            }
        }

        boolean getRollbackOnly() {
            return this.rollbackOnly;
        }

        boolean isUserTransaction() {
            return this.userTransaction;
        }

        public void setRolledBack() {
            this.rolledBack = true;
            if (this.previous != null && (this.transactionAttributeType == TransactionAttributeType.REQUIRED || this.transactionAttributeType == TransactionAttributeType.SUPPORTS || this.transactionAttributeType == TransactionAttributeType.MANDATORY) && this.previous.transactionAttributeType != TransactionAttributeType.NOT_SUPPORTED) {
                this.previous.setRolledBack();
            }
        }

        public boolean isRolledBack() {
            return this.rolledBack;
        }

        public int getStatus() {
            if (this.isUserTransaction() || this.transactionAttributeType == TransactionAttributeType.REQUIRED || this.transactionAttributeType == TransactionAttributeType.REQUIRES_NEW || this.transactionAttributeType == TransactionAttributeType.MANDATORY) {
                if (this.getRollbackOnly()) {
                    return 1;
                }
                if (this.isRolledBack()) {
                    return 6;
                }
                return 0;
            }
            if (this.transactionAttributeType == TransactionAttributeType.SUPPORTS) {
                return this.getPrevious() != null ? this.getPrevious().getStatus() : 6;
            }
            return 6;
        }
    }
}

