/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.SessionContextFactory;
import com.oneandone.ejbcdiunit.internal.EjbExtensionExtended;
import com.oneandone.ejbcdiunit.persistence.PersistenceFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.ejb.HibernatePersistence;
import org.jglue.cdiunit.AdditionalClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@AdditionalClasses(value={SessionContextFactory.class})
public class TestPersistenceFactory
extends PersistenceFactory {
    public static Set<String> notFoundPersistenceUnits = new HashSet<String>();
    static Logger logger = LoggerFactory.getLogger((String)"TestPersistenceFactory");
    @Inject
    EjbExtensionExtended ejbExtensionExtended;

    @Override
    protected String getPersistenceUnitName() {
        return "test";
    }

    @Override
    @Produces
    @Default
    public EntityManager produceEntityManager() {
        return super.produceEntityManager();
    }

    @Override
    @Produces
    @Default
    public DataSource produceDataSource() {
        return super.produceDataSource();
    }

    public EjbExtensionExtended getEjbExtensionExtended() {
        return this.ejbExtensionExtended;
    }

    protected PersistenceUnitInfo testPersistenceUnitInfo() {
        return new PersistenceUnitInfo(){

            public String getPersistenceUnitName() {
                return "TestPersistenceUnit";
            }

            public String getPersistenceProviderClassName() {
                return "org.hibernate.ejb.HibernatePersistence";
            }

            public PersistenceUnitTransactionType getTransactionType() {
                return PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }

            public DataSource getJtaDataSource() {
                return null;
            }

            public DataSource getNonJtaDataSource() {
                BasicDataSource bds = new BasicDataSource();
                bds.setDriverClassName(System.getProperty("hibernate.connection.driverclass", "org.h2.Driver"));
                bds.setUrl(System.getProperty("hibernate.connection.url", "jdbc:h2:mem:test;MODE=MySQL;DB_CLOSE_ON_EXIT=TRUE;DB_CLOSE_DELAY=0;LOCK_MODE=0;LOCK_TIMEOUT=10000"));
                bds.setUsername(System.getProperty("hibernate.connection.username", "sa"));
                bds.setPassword(System.getProperty("hibernate.connection.password", ""));
                return bds;
            }

            public List<String> getMappingFileNames() {
                return Collections.emptyList();
            }

            public List<URL> getJarFileUrls() {
                try {
                    ArrayList<URL> jarFiles = Collections.list(this.getClass().getClassLoader().getResources(""));
                    logger.info("getJarFileUrls: {}", jarFiles);
                    return jarFiles;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public URL getPersistenceUnitRootUrl() {
                try {
                    Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
                    if (resources.hasMoreElements()) {
                        return resources.nextElement();
                    }
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }

            public List<String> getManagedClassNames() {
                ArrayList<String> result = new ArrayList<String>();
                for (Class<?> c : TestPersistenceFactory.this.getEjbExtensionExtended().getEntityClasses()) {
                    result.add(c.getName());
                }
                return result;
            }

            public boolean excludeUnlistedClasses() {
                return false;
            }

            public SharedCacheMode getSharedCacheMode() {
                return null;
            }

            public ValidationMode getValidationMode() {
                return null;
            }

            public Properties getProperties() {
                return new Properties();
            }

            public String getPersistenceXMLSchemaVersion() {
                return null;
            }

            public ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public void addTransformer(ClassTransformer transformer) {
            }

            public ClassLoader getNewTempClassLoader() {
                return this.getClassLoader();
            }
        };
    }

    @Override
    protected EntityManagerFactory createEntityManagerFactory() {
        Throwable possiblyToThrow = null;
        if (!notFoundPersistenceUnits.contains(this.getPersistenceUnitName())) {
            try {
                return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
            }
            catch (Throwable e) {
                possiblyToThrow = e;
                notFoundPersistenceUnits.add(this.getPersistenceUnitName());
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
        properties.put("hibernate.show_sql", true);
        properties.put("hibernate.hbm2ddl.auto", "create-drop");
        properties.put("hibernate.id.new_generator_mappings", false);
        properties.put("hibernate.archive.autodetection", "class");
        for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
            properties.put((String)p.getKey(), p.getValue());
        }
        PersistenceUnitInfo persistenceUnitInfo = this.testPersistenceUnitInfo();
        try {
            return new HibernatePersistence().createContainerEntityManagerFactory(persistenceUnitInfo, properties);
        }
        catch (Throwable thw) {
            if (possiblyToThrow != null) {
                throw new RuntimeException(possiblyToThrow);
            }
            throw (RuntimeException)thw;
        }
    }
}

