/*
 * Decompiled with CFR 0.152.
 */
package com.oneandone.ejbcdiunit.persistence;

import com.oneandone.ejbcdiunit.persistence.PersistenceFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.slf4j.MDC;

public class TestTransactionBase {
    private final PersistenceFactory persistenceFactory;
    private final TransactionAttributeType transactionAttribute;
    private boolean dropEntityManager = false;
    private boolean closeIt = false;
    private boolean isClosed = false;
    static AtomicInteger tracounter = new AtomicInteger(0);
    private Integer lastXid = null;
    private TestTransactionBase embedding;

    public TestTransactionBase(PersistenceFactory persistenceFactory, TransactionAttributeType transactionAttribute, TestTransactionBase embedding) {
        EntityTransaction tra;
        this.persistenceFactory = persistenceFactory;
        this.transactionAttribute = transactionAttribute;
        this.embedding = embedding;
        EntityTransaction entityTransaction = tra = embedding == null ? null : persistenceFactory.getEntityManager().getTransaction();
        if (embedding != null && embedding.transactionAttribute == TransactionAttributeType.NOT_SUPPORTED) {
            embedding.getPersistenceFactory().getEntityManager().clear();
        }
        switch (transactionAttribute) {
            case SUPPORTS: {
                if (embedding != null) break;
                persistenceFactory.createAndRegister();
                this.dropEntityManager = true;
                break;
            }
            case NOT_SUPPORTED: {
                persistenceFactory.createAndRegister();
                this.dropEntityManager = true;
                break;
            }
            case NEVER: {
                if (tra.isActive()) {
                    throw new TransactionRequiredException("Transaction is not allowed");
                }
                persistenceFactory.createAndRegister();
                this.dropEntityManager = true;
                break;
            }
            case MANDATORY: {
                if (embedding != null && tra.isActive()) break;
                throw new TransactionRequiredException("Mandatory Transaction");
            }
            case REQUIRED: {
                if (embedding != null && embedding.traActive()) break;
                persistenceFactory.createAndRegister();
                tra = persistenceFactory.getEntityManager().getTransaction();
                this.dropEntityManager = true;
                this.closeIt = true;
                tra.begin();
                this.newXid();
                break;
            }
            case REQUIRES_NEW: {
                persistenceFactory.createAndRegister();
                persistenceFactory.getEntityManager().getTransaction().begin();
                this.newXid();
                this.closeIt = true;
                this.dropEntityManager = true;
                break;
            }
            default: {
                throw new RuntimeException("Invalid TransactionAttribute " + transactionAttribute);
            }
        }
    }

    private boolean traActive() {
        switch (this.transactionAttribute) {
            case NOT_SUPPORTED: {
                return false;
            }
            case REQUIRED: 
            case REQUIRES_NEW: {
                return true;
            }
            case SUPPORTS: {
                if (this.embedding == null) {
                    return false;
                }
                return this.embedding.traActive();
            }
            case NEVER: {
                return false;
            }
            case MANDATORY: {
                return true;
            }
        }
        throw new RuntimeException("unexpected transaction attribute: " + this.transactionAttribute);
    }

    private void newXid() {
        assert (this.lastXid == null);
        if (MDC.get((String)"XID") != null) {
            this.lastXid = Integer.parseInt(MDC.get((String)"XID"));
        }
        MDC.put((String)"XID", (String)Integer.toString(tracounter.incrementAndGet()));
    }

    private void resetXid() {
        if (this.lastXid != null) {
            MDC.put((String)"XID", (String)Integer.toString(this.lastXid));
        } else {
            MDC.remove((String)"XID");
        }
        this.lastXid = null;
    }

    public void close() throws Exception {
        this.close(false);
    }

    public void close(boolean rollbackOnly) throws Exception {
        if (!this.isClosed) {
            try {
                if (this.closeIt) {
                    EntityTransaction tra = this.persistenceFactory.getEntityManager().getTransaction();
                    if (tra.isActive()) {
                        if (rollbackOnly || tra.getRollbackOnly()) {
                            tra.rollback();
                        } else {
                            tra.commit();
                        }
                    }
                    this.resetXid();
                }
            }
            finally {
                if (this.dropEntityManager) {
                    this.persistenceFactory.unRegister();
                    this.dropEntityManager = false;
                }
                this.isClosed = true;
            }
        }
    }

    public PersistenceFactory getPersistenceFactory() {
        return this.persistenceFactory;
    }

    void rollback() {
        EntityTransaction tra = this.persistenceFactory.getEntityManager().getTransaction();
        try {
            if (tra.isActive()) {
                tra.rollback();
                this.resetXid();
            }
        }
        finally {
            if (!this.dropEntityManager && this.embedding != null) {
                this.embedding.rollback();
            }
        }
    }
}

