/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.oneandone.jasmin.cache.Item;

public abstract class Cache<K, V> {
    protected final LinkedHashMap<K, Item<V>> items = new LinkedHashMap(16, 0.75f, true);
    protected final int maxSize;
    private int size;
    private int lookups;
    private int misses;
    private long addedBytes;
    private long removedBytes;

    public Cache(int maxSize) {
        this.maxSize = maxSize;
        this.size = 0;
        this.lookups = 0;
        this.misses = 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public abstract int valueSize(V var1);

    public synchronized V lookup(K key) {
        ++this.lookups;
        Item<V> item = this.items.get(key);
        if (item != null) {
            item.accessTime = System.currentTimeMillis();
            ++item.accessCount;
            return (V)item.value;
        }
        ++this.misses;
        return null;
    }

    public synchronized void add(K key, V value, long created, long duration) {
        Item<V> item = new Item<V>(value, created, duration);
        Item<V> concurrent = this.items.put(key, item);
        if (concurrent != null) {
            this.size -= this.valueSize(concurrent.value);
        }
        int valueSize = this.valueSize(item.value);
        this.size += valueSize;
        this.addedBytes += (long)valueSize;
        item.accessTime = created;
        ++item.accessCount;
        this.shrink(this.maxSize);
    }

    public synchronized V probe(K key) {
        Item<V> item = this.items.get(key);
        return item == null ? null : (V)item.value;
    }

    public synchronized void resize(int max) {
        this.shrink(max);
    }

    private void shrink(int max) {
        if (this.size > max) {
            Iterator<Map.Entry<K, Item<V>>> iter = this.items.entrySet().iterator();
            while (iter.hasNext()) {
                Item<V> item = iter.next().getValue();
                int valueSize = this.valueSize(item.value);
                this.removedBytes += (long)valueSize;
                this.size -= valueSize;
                iter.remove();
                if (this.size > max) continue;
            }
            if (this.size < 0) {
                throw new IllegalStateException();
            }
            if (this.items.size() == 0 && this.size != 0) {
                throw new IllegalStateException();
            }
        }
    }

    public synchronized int items() {
        return this.items.size();
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized int misses() {
        return this.misses;
    }

    public synchronized int gets() {
        return this.lookups;
    }

    public synchronized long addedBytes() {
        return this.addedBytes;
    }

    public synchronized long removedBytes() {
        return this.removedBytes;
    }

    public synchronized void validate() {
        int s = 0;
        for (Item<V> item : this.items.values()) {
            s += this.valueSize(item.value);
        }
        if (s != this.size) {
            throw new IllegalStateException(s + " != " + this.size);
        }
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("size: ").append(this.maxSize).append(" (").append(this.maxSize == 0 ? 100 : this.size * 100 / this.maxSize).append("% used)\n");
        int count = this.gets();
        int percent = count == 0 ? 0 : (count - this.misses) * 100 / count;
        builder.append("lookups: ").append(count).append(" (").append(percent).append("% hits)\n");
        for (Map.Entry<K, Item<V>> entry : this.items.entrySet()) {
            Item<V> item = entry.getValue();
            this.entryToString(entry.getKey(), item.value, builder);
            builder.append(" - ").append(item.stats()).append("\n");
        }
        return builder.toString();
    }

    protected abstract void entryToString(K var1, V var2, StringBuilder var3);
}

