/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.cache;

import java.text.SimpleDateFormat;

public class Item<T> {
    public final T value;
    public final long createTime;
    public final long duration;
    public long accessTime;
    public int accessCount;
    public static final SimpleDateFormat FORMATTER = new SimpleDateFormat("dd.MM.yy HH:mm:ss");

    public Item(T value, long createTime, long duration) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        this.createTime = createTime;
        this.duration = duration;
        this.accessTime = 0L;
        this.accessCount = 0;
    }

    public synchronized String stats() {
        return this.accessCount + " (" + FORMATTER.format(this.accessTime) + "), " + this.duration + " ms";
    }
}

