/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.main;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import net.oneandone.jasmin.descriptor.Base;
import net.oneandone.jasmin.model.Attributes;
import net.oneandone.jasmin.model.Engine;
import net.oneandone.jasmin.model.Repository;
import net.oneandone.jasmin.model.Resolver;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;

public class Application {
    private final ServletContext context;
    public final Resolver resolver;
    public final Node applicationDescriptor;
    public final Integer expires;
    public static final int MANY_YEARS = 473040000;

    public static Application load(World world, ServletConfig config, FileNode docroot) throws Exception {
        String str = Application.getString(config, "project", null);
        if (str != null) {
            throw new IOException("'project' parameter no longer supported");
        }
        boolean autoReload = !"prod".equals(config.getServletContext().getInitParameter("mode"));
        autoReload = Application.getBoolean(config, "autoReload", autoReload);
        Resolver resolver = new Resolver(world, autoReload);
        Node applicationDescriptor = Application.getApplicationDescriptor(config, docroot, resolver);
        Integer expires = Application.getInteger(config, "expires", 473040000);
        return new Application(config.getServletContext(), resolver, applicationDescriptor, expires);
    }

    public static FileNode file(World world, String str) throws IOException {
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return world.file(new File(str).getCanonicalFile());
    }

    private static Node getApplicationDescriptor(ServletConfig config, FileNode application, Resolver resolver) throws Exception {
        String explicit = Application.getString(config, "projectDescriptor", null);
        if (explicit != null) {
            throw new IOException("'projectDescriptor' parameter no longer supported");
        }
        Node result = application.join(new String[]{"WEB-INF/jasmin.xml"});
        if (!result.exists()) {
            return null;
        }
        Node resolvedProject = resolver.resolve((Node)application, result.getRelative((Node)application));
        if (resolvedProject != null) {
            result = resolvedProject;
        }
        return result;
    }

    public Application(ServletContext context, Resolver resolver, Node applicationDescriptor, Integer expires) {
        this.context = context;
        this.resolver = resolver;
        this.applicationDescriptor = applicationDescriptor;
        this.expires = expires;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public Engine createEngineSimple(Node docroot, Node localhost) throws IOException {
        return (Engine)this.createEngine(docroot, localhost)[0];
    }

    public Object[] createEngine(Node docroot, Node localhost) throws IOException {
        this.resolver.add(Base.DOCROOT, docroot);
        this.resolver.add(Base.LOCALHOST, localhost);
        try {
            Repository repository = new Repository(new Attributes(){

                @Override
                public Object get(String name) {
                    return Application.this.context.getAttribute(name);
                }
            });
            repository.loadClasspath(this.resolver);
            if (this.applicationDescriptor != null) {
                repository.loadApplication(this.resolver, docroot, this.applicationDescriptor);
            }
            List<Node> reloadFiles = repository.link();
            return new Object[]{new Engine(repository), reloadFiles};
        }
        catch (Throwable e) {
            this.resolver.reset();
            throw e;
        }
    }

    private static Boolean getBoolean(ServletConfig config, String key, boolean dflt) {
        String value = Application.getString(config, key, null);
        if (value == null) {
            return dflt;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(key + ": 'true' or 'false' expected, got '" + value + "'");
    }

    private static Integer getInteger(ServletConfig config, String key, Integer dflt) {
        String str = Application.getString(config, key, null);
        return str == null ? dflt : Integer.valueOf(str);
    }

    private static String getString(ServletConfig config, String key, String dflt) {
        String result = config.getInitParameter(key);
        return result == null ? dflt : result;
    }
}

