/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.main;

import java.io.IOException;
import java.util.List;
import net.oneandone.jasmin.main.Runner;
import net.oneandone.jasmin.model.Engine;

public class Client
extends Thread {
    private final Engine engine;
    private final List<String> paths;
    private final int requests;
    private final boolean random;
    private final boolean lastModified;
    private Exception exception;

    public Client(Engine engine, List<String> paths, int requests, boolean random, boolean lastModified) {
        this.engine = engine;
        this.paths = paths;
        this.requests = requests;
        this.random = random;
        this.lastModified = lastModified;
        this.exception = null;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public void doRun() throws IOException {
        for (int i = 0; i < this.requests; ++i) {
            String path = this.random ? this.paths.get(Runner.RANDOM.nextInt(this.paths.size())) : this.paths.get(i % this.paths.size());
            if (this.lastModified && Runner.RANDOM.nextBoolean()) {
                this.engine.getLastModified(path);
                continue;
            }
            this.get(path);
        }
    }

    public void get(String path) throws IOException {
        long started = System.currentTimeMillis();
        try {
            String str = this.engine.request(path);
            Runner.LOG.info(path + ": " + str.length() + " chars, " + (System.currentTimeMillis() - started) + " ms");
        }
        catch (IOException e) {
            Runner.LOG.error(path, (Throwable)e);
            throw e;
        }
    }

    public void finish() throws Exception {
        this.join();
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

