/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.main;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oneandone.jasmin.descriptor.Base;
import net.oneandone.jasmin.model.File;
import net.oneandone.jasmin.model.Module;
import net.oneandone.jasmin.model.References;
import net.oneandone.jasmin.model.Repository;
import net.oneandone.jasmin.model.Resolver;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.NodeWriter;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCheck {
    private static final Logger LOG = LoggerFactory.getLogger(FileCheck.class);
    private final Map<Node, List<Exception>> map;

    public FileCheck() {
        this(new HashMap<Node, List<Exception>>());
    }

    public FileCheck(Map<Node, List<Exception>> map) {
        this.map = map;
    }

    public FileCheck exceptions() {
        HashMap<Node, List<Exception>> result = new HashMap<Node, List<Exception>>();
        for (Map.Entry<Node, List<Exception>> entry : this.map.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return new FileCheck(result);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Node, List<Exception>> entry : this.map.entrySet()) {
            result.append(entry.getKey().getUri()).append('\n');
            for (Exception e : entry.getValue()) {
                result.append("  ").append(e.getMessage()).append('\n');
            }
        }
        return result.toString();
    }

    public void add(Node node) {
        if (!this.map.containsKey(node)) {
            this.map.put(node, new ArrayList());
        }
    }

    public void add(Node node, Exception e) {
        this.map.get(node).add(e);
    }

    public void minimizeClasspath() throws IOException {
        World world = World.create();
        Resolver resolver = new Resolver(world);
        this.minimize(false, Repository.load(resolver), world);
    }

    public void minimizeApplication(FileNode application) throws IOException {
        World world = World.create();
        Resolver resolver = new Resolver(world);
        resolver.add(Base.DOCROOT, (Node)application);
        resolver.add(Base.LOCALHOST, world.validNode("http://nosuchhost"));
        Repository repository = new Repository();
        repository.loadClasspath(resolver);
        Node descriptor = application.join(new String[]{"conf/jasmin.xml"});
        if (descriptor.exists()) {
            throw new IllegalStateException("unexpected location for descriptor: " + descriptor);
        }
        descriptor = application.join(new String[]{"WEB-INF/jasmin.xml"});
        if (descriptor.exists()) {
            repository.loadApplication(resolver, (Node)application, descriptor);
        }
        repository.link();
        this.minimize(false, repository, application.getWorld());
    }

    public void minimize(boolean http, Repository repository, World world) throws IOException {
        for (Module module : repository.modules()) {
            for (File file : module.files()) {
                Node src = file.getNormal();
                if (!http && "http".equals(src.getRoot().getFilesystem().getScheme())) continue;
                this.add(src);
                try {
                    FileNode dest = world.getTemp().createTempFile();
                    LOG.info("fileCheck module=" + module.getName() + ", file=" + src);
                    long started = System.currentTimeMillis();
                    try (NodeWriter writer = dest.newWriter();){
                        References.create(file.getType(), true, src).writeTo((Writer)writer);
                    }
                    LOG.info("done, " + (System.currentTimeMillis() - started) + " ms");
                    dest.deleteFile();
                }
                catch (Exception e) {
                    this.add(src, e);
                }
            }
        }
    }

    public int size() {
        return this.map.size();
    }
}

