/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.oneandone.jasmin.main.Application;
import net.oneandone.jasmin.main.Client;
import net.oneandone.jasmin.model.Engine;
import net.oneandone.jasmin.model.Module;
import net.oneandone.jasmin.model.Repository;
import net.oneandone.jasmin.model.Resolver;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner {
    public static final Random RANDOM = new Random();
    public static final Logger LOG = LoggerFactory.getLogger(Runner.class);
    private final String name;
    private final Engine engine;
    private final List<String> paths;

    public static Runner create(String name, World world) throws IOException {
        FileNode base = world.guessProjectHome(Runner.class);
        Application application = new Application(null, new Resolver(world), null, null);
        FileNode localhost = world.getTemp().createTempDirectory();
        Engine engine = application.createEngineSimple(base.getParent(), (Node)localhost);
        return new Runner(name, engine);
    }

    public Runner(String name, Engine engine) {
        this.name = name;
        this.engine = engine;
        this.paths = new ArrayList<String>();
    }

    public int pathCount() {
        return this.paths.size();
    }

    public Runner add(Node<?> log, String application, int max) throws IOException {
        for (String line : log.readLines()) {
            line = line.trim();
            if (!(line = line.substring(line.indexOf(124) + 1)).startsWith(application)) continue;
            line = line.substring(application.length());
            line = line.substring(0, line.indexOf(32));
            this.paths.add(line);
            if (this.paths.size() != max) continue;
            break;
        }
        return this;
    }

    public Runner addAll() {
        Repository repository = this.engine.repository;
        List<String> variants = repository.getVariants();
        for (Module module : repository.modules()) {
            this.addTypes(module, "head");
            for (String variant : variants) {
                this.addTypes(module, variant);
            }
        }
        return this;
    }

    public void addTypes(Module module, String variant) {
        this.add(module.getName() + "/js/" + variant);
        this.add(module.getName() + "/js-min/" + variant);
        this.add(module.getName() + "/css/" + variant);
        this.add(module.getName() + "/css-min/" + variant);
    }

    public Runner add(String ... pathList) {
        this.paths.addAll(Arrays.asList(pathList));
        return this;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void invoke() throws Exception {
        this.invoke(1, this.paths.size(), false, false, true);
    }

    public void invoke(int clientCount, int requestCount) throws Exception {
        this.invoke(clientCount, requestCount, true, true, true);
    }

    public void invoke(int clientCount, int requestCount, boolean random, boolean lastModified, boolean stats) throws Exception {
        if (stats) {
            System.out.println("[" + this.name + "]\t" + clientCount + " client(s) a " + requestCount + " requests (random=" + random + ", lastModified=" + lastModified + ")");
        }
        long started = System.currentTimeMillis();
        Client[] clients = new Client[clientCount];
        for (int i = 0; i < clients.length; ++i) {
            clients[i] = new Client(this.engine, this.paths, requestCount, random, lastModified);
            clients[i].start();
        }
        for (Client client : clients) {
            client.finish();
        }
        if (stats) {
            this.stats(started);
        }
    }

    private void stats(long started) {
        System.out.println();
        Runner.usedMemory();
        Runner.runGC();
        System.out.println("  ms:          " + (System.currentTimeMillis() - started));
        long used = Runner.usedMemory();
        this.engine.free();
        Runner.runGC();
        System.out.println("  mem:         " + (used - Runner.usedMemory()));
        System.out.println();
        System.out.println();
    }

    private static void runGC() {
        for (int r = 0; r < 4; ++r) {
            Runner.doRunGC();
        }
    }

    private static void doRunGC() {
        long used = Runner.usedMemory();
        long prev = Long.MAX_VALUE;
        for (int i = 0; used < prev && i < 500; ++i) {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            prev = used;
            used = Runner.usedMemory();
        }
    }

    private static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

