/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.main;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oneandone.jasmin.main.Application;
import net.oneandone.jasmin.main.FileCheck;
import net.oneandone.jasmin.model.Engine;
import net.oneandone.jasmin.model.File;
import net.oneandone.jasmin.model.Module;
import net.oneandone.jasmin.model.Resolver;
import net.oneandone.jasmin.model.Source;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.fs.http.HttpFilesystem;
import net.oneandone.sushi.fs.http.HttpNode;
import net.oneandone.sushi.util.Strings;
import org.json.JSONException;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    public static final Logger LOG = LoggerFactory.getLogger(Servlet.class);
    private static final String HOSTNAME = Servlet.getHostname();
    private List<Node> reloadFiles;
    private long loaded;
    private long otherVmStartupDate = VM_STARTUP_DATE.getTime() - 315360000000L;
    private FileNode docroot;
    private Application application;
    private Engine engine;
    private static final int HTTP_TIMEOUT = 10000;
    private static final String MODULE_PREFIX = "/admin/module/";
    private static final long FIVE_MINUTES = 300000L;
    private static final long SEVEN_DAYS = 604800000L;
    private static final long TEN_YEARS = 315360000000L;
    public static final SimpleDateFormat FMT = new SimpleDateFormat("yyMMdd-HHmm");
    public static final Date VM_STARTUP_DATE = new Date();
    public static final long VM_STARTUP = VM_STARTUP_DATE.getTime();
    public static final String VM_STARTUP_STR = FMT.format(VM_STARTUP_DATE);

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("unknown hostname", (Throwable)e);
            return "unknown";
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            World world = World.create();
            Servlet.configure(world, "http");
            Servlet.configure(world, "https");
            String str = config.getInitParameter("docroot");
            this.docroot = Application.file(world, str != null ? str : config.getServletContext().getRealPath(""));
            this.docroot.checkDirectory();
            LOG.info("home: " + world.getHome());
            this.application = Application.load(world, config, this.docroot);
            LOG.info("docroot: " + this.docroot);
        }
        catch (Error | RuntimeException e) {
            this.error(null, "init", e);
            throw e;
        }
        catch (Exception e) {
            this.error(null, "init", e);
            throw new ServletException((Throwable)e);
        }
        catch (Throwable e) {
            this.error(null, "init", e);
            throw new RuntimeException("unexpected throwable", e);
        }
    }

    private static void configure(World world, String scheme) {
        HttpFilesystem webdav = (HttpFilesystem)world.getFilesystem(scheme, HttpFilesystem.class);
        webdav.setDefaultConnectionTimeout(10000);
        webdav.setDefaultReadTimeout(10000);
    }

    private synchronized void lazyInit(HttpServletRequest request) throws IOException {
        Resolver resolver = this.application.resolver;
        if (this.engine != null && resolver.isLife()) {
            for (Node node : this.reloadFiles) {
                long lastModified = node.getLastModified();
                if (lastModified <= this.loaded) continue;
                long now = System.currentTimeMillis();
                if (lastModified > now) {
                    throw new IOException(node.getUri() + " has lastModifiedDate in the future: " + new Date(lastModified) + "(now: " + new Date(now) + ")");
                }
                LOG.info("reloading jasmin for application '" + this.application.getContextPath() + "' - changed file: " + node);
                this.engine = null;
                resolver.reset();
            }
        }
        if (this.engine == null) {
            Node localhost;
            URL url = new URL(request.getRequestURL().toString());
            try {
                localhost = resolver.getWorld().node(new URI(url.getProtocol(), null, url.getHost(), url.getPort(), "", null, null));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
            Object[] tmp = this.application.createEngine((Node)this.docroot, localhost);
            this.engine = (Engine)tmp[0];
            LOG.info("started engine, initial url=" + url);
            for (Module module : this.engine.repository.modules()) {
                List<File> files = module.files();
                if (files.size() > 2) {
                    LOG.warn("deprecated: module '" + module.getName() + "' contains more than 2 file: " + files);
                }
                for (File f : files) {
                    if (!(f.getNormal() instanceof HttpNode)) continue;
                    LOG.warn("deprecated: module '" + module.getName() + "' uses base LOCALHOST: " + f.getNormal().getUri());
                }
            }
            if (resolver.isLife()) {
                this.reloadFiles = (List)tmp[1];
                FileNode file = resolver.getLiveXml();
                if (file != null) {
                    this.reloadFiles.add((Node)file);
                }
                LOG.info("reload if one of these " + this.reloadFiles.size() + " files is modified: ");
                for (Node node : this.reloadFiles) {
                    LOG.info("  " + node.getUri());
                }
                this.loaded = System.currentTimeMillis();
            }
            if (this.engine == null) {
                throw new IllegalStateException();
            }
        }
    }

    public long getLastModified(HttpServletRequest request) {
        long result = -1L;
        try {
            String path = request.getPathInfo();
            if (path != null && path.startsWith("/get/")) {
                this.lazyInit(request);
                path = path.substring(5);
                int idx = path.indexOf(47);
                if (idx != -1) {
                    path = path.substring(idx + 1);
                    result = this.engine.getLastModified(path);
                }
            }
        }
        catch (IOException e) {
            this.error(request, "getLastModified", e);
        }
        catch (Error | RuntimeException e) {
            this.error(request, "getLastModified", e);
            throw e;
        }
        LOG.debug("getLastModified(" + request.getPathInfo() + ") -> " + result);
        return result;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doGetUnchecked(request, response);
        }
        catch (IOException e) {
            if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                LOG.info("aborted by client", (Throwable)e);
            } else {
                this.error(request, "get", e);
            }
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.error(request, "get", e);
            throw e;
        }
    }

    private void doGetUnchecked(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        if (path == null) {
            response.sendRedirect(request.getContextPath() + request.getServletPath() + "/");
            return;
        }
        this.lazyInit(request);
        LOG.debug("get " + path);
        if (path.startsWith("/get/")) {
            this.get(request, response, path.substring(5));
            return;
        }
        if (path.equals("/admin/")) {
            this.main(response);
            return;
        }
        if (path.equals("/admin/repository")) {
            this.repository(request, response);
            return;
        }
        if (path.equals("/admin/hashCache")) {
            this.hashCache(response);
            return;
        }
        if (path.equals("/admin/contentCache")) {
            this.contentCache(response);
            return;
        }
        if (path.startsWith(MODULE_PREFIX)) {
            this.module(request, response, path.substring(MODULE_PREFIX.length()));
            return;
        }
        if (path.equals("/admin/reload")) {
            this.reload(response);
            return;
        }
        if (path.equals("/admin/check")) {
            this.fileCheck(response);
            return;
        }
        this.notFound(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        boolean expire;
        int idx = path.indexOf(47);
        if (idx == -1) {
            this.notFound(request, response);
            return;
        }
        long started = System.currentTimeMillis();
        String version = path.substring(0, idx);
        boolean bl = expire = !"no-expires".equals(version);
        if (expire && !VM_STARTUP_STR.equals(version)) {
            long date;
            try {
                SimpleDateFormat simpleDateFormat = FMT;
                synchronized (simpleDateFormat) {
                    date = FMT.parse(version).getTime();
                }
            }
            catch (ParseException e) {
                this.notFound(request, response);
                return;
            }
            if (!Servlet.sameTime(VM_STARTUP, date) && !Servlet.sameTime(this.otherVmStartupDate, date)) {
                if (date > this.otherVmStartupDate) {
                    this.otherVmStartupDate = date;
                } else if (Math.min(this.otherVmStartupDate, VM_STARTUP) - date > 604800000L) {
                    this.gone(request, response);
                    return;
                }
            }
        }
        path = path.substring(idx + 1);
        if (this.application.resolver.isLife()) {
            response.addHeader("Hi", "Sie werden bedient von Jasmin, vielen Dank fuer ihren Request!");
        }
        Servlet.checkCharset(request.getHeader("Accept-Charset"));
        if (expire && this.application.expires != null) {
            response.setDateHeader("Expires", started + 1000L * (long)this.application.expires.intValue());
            response.addHeader("Cache-Control", "max-age=" + this.application.expires);
        }
        boolean gzip = Servlet.canGzip(request);
        int bytes = this.engine.request(path, response, gzip);
        long duration = System.currentTimeMillis() - started;
        LOG.info(path + "|" + bytes + "|" + duration + "|" + gzip + "|" + Servlet.referer(request));
    }

    private static boolean sameTime(long left, long right) {
        long diff = left - right;
        if (diff < 0L) {
            diff = -diff;
        }
        return diff < 300000L;
    }

    private static boolean canGzip(HttpServletRequest request) {
        String accepted = request.getHeader("Accept-Encoding");
        return accepted != null && Servlet.contains(accepted, "gzip");
    }

    public static void checkCharset(String accepts) throws IOException {
        if (accepts == null) {
            return;
        }
        if (Servlet.contains(accepts.toLowerCase(), "utf-8")) {
            return;
        }
        if (Servlet.contains(accepts, "*")) {
            return;
        }
        throw new IOException("utf-8 encoding is not accepted: " + accepts);
    }

    public static boolean contains(String list, String keyword) {
        String quality;
        int idx = list.indexOf(keyword);
        if (idx == -1) {
            return false;
        }
        int colon = list.indexOf(",", idx += keyword.length());
        if (colon == -1) {
            colon = list.length();
        }
        if ((idx = (quality = list.substring(idx, colon)).indexOf(61)) == -1) {
            return true;
        }
        return !"0".equals(quality.substring(idx + 1).trim());
    }

    private void main(HttpServletResponse response) throws IOException {
        this.html(response, "<p>Jasmin Servlet " + this.getVersion() + "</p>", "<p>Hostname: " + HOSTNAME + "</p>", "<p>Docroot: " + this.docroot.getAbsolute() + "</p>", "<p>VM Startup: " + VM_STARTUP_STR + "</p>", "<p>Other VM Startup: " + FMT.format(this.otherVmStartupDate) + "</p>", "<p>Loaded: " + new Date(this.loaded) + "</p>", "<p>HashCache: " + this.engine.hashCache.getMaxSize() + "</p>", "<p>ContentCache: " + this.engine.contentCache.getMaxSize() + "</p>", "<p>Requested Bytes: " + this.engine.requestedBytes.get() + "</p>", "<p>Computed Bytes: " + this.engine.computedBytes() + "</p>", "<p>Removed Bytes: " + this.engine.removedBytes() + "</p>", "<p>Load: " + this.engine.load() + "</p>", this.application.resolver.isLife() ? "<a href='reload'>Reload Files</a>" : "(no reload)", "<a href='repository'>Repository</a>", "<a href='hashCache'>Hash Cache</a>", "<a href='contentCache'>Content Cache</a>", "<a href='check'>File Check</a>");
    }

    private String getVersion() {
        return ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
    }

    private void repository(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        try (PrintWriter writer = response.getWriter();){
            JSONWriter dest = new JSONWriter((Writer)writer);
            dest.array();
            ArrayList<Module> modules = new ArrayList<Module>(this.engine.repository.modules());
            Collections.sort(modules, new Comparator<Module>(){

                @Override
                public int compare(Module left, Module right) {
                    return left.getName().compareTo(right.getName());
                }
            });
            for (Module module : modules) {
                dest.object();
                dest.key("name");
                dest.value((Object)module.getName());
                dest.key("details");
                dest.value((Object)(Strings.removeRight((String)request.getRequestURL().toString(), (String)"/repository") + "/module/" + module.getName()));
                dest.endObject();
            }
            dest.endArray();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void hashCache(HttpServletResponse response) throws IOException {
        this.text(response, this.engine.hashCache.toString());
    }

    private void contentCache(HttpServletResponse response) throws IOException {
        this.text(response, this.engine.contentCache.toString());
    }

    private void module(HttpServletRequest request, HttpServletResponse response, String name) throws IOException {
        Module module = this.engine.repository.lookup(name);
        Source source = module.getSource();
        if (module == null) {
            this.notFound(request, response);
            return;
        }
        response.setContentType("application/json");
        try (PrintWriter writer = response.getWriter();){
            JSONWriter dest = new JSONWriter((Writer)writer);
            dest.object();
            dest.key("name");
            dest.value((Object)module.getName());
            dest.key("files");
            dest.array();
            for (File file : module.files()) {
                dest.object();
                dest.key("type");
                dest.value((Object)file.getType());
                dest.key("normal");
                dest.value((Object)file.getNormal().getUri());
                if (file.getMinimized() != null) {
                    dest.key("minimized");
                    dest.value((Object)file.getMinimized().getUri());
                }
                dest.key("variant");
                dest.value((Object)file.getVariant());
                dest.endObject();
            }
            dest.endArray();
            dest.key("dependencies");
            dest.array();
            for (Module dependency : module.dependencies()) {
                dest.value((Object)dependency.getName());
            }
            dest.endArray();
            dest.key("source");
            dest.object();
            dest.key("artifactId");
            dest.value((Object)source.artifactId);
            dest.key("groupId");
            dest.value((Object)source.groupId);
            dest.key("version");
            dest.value((Object)source.version);
            dest.key("scm");
            dest.value((Object)source.scm);
            dest.endObject();
            dest.endObject();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void reload(HttpServletResponse response) throws IOException {
        String[] lines = new String[this.reloadFiles.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = this.reloadFiles.get(i).getUri().toString();
        }
        this.text(response, lines);
    }

    private void fileCheck(HttpServletResponse response) throws IOException {
        FileCheck check = new FileCheck();
        check.minimize(true, this.engine.repository, this.application.resolver.getWorld());
        this.text(response, check.toString());
    }

    private void text(HttpServletResponse response, String ... lines) throws IOException {
        response.setContentType("text/plain");
        try (PrintWriter writer = response.getWriter();){
            for (String line : lines) {
                ((Writer)writer).write(line);
                ((Writer)writer).write(10);
            }
        }
    }

    private void html(HttpServletResponse response, String ... lines) throws IOException {
        response.setContentType("text/html");
        try (PrintWriter writer = response.getWriter();){
            ((Writer)writer).write("<html><header></header><body>\n");
            for (String line : lines) {
                ((Writer)writer).write(line);
                ((Writer)writer).write(10);
            }
            ((Writer)writer).write("</body>");
        }
    }

    private void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.warn("not found: " + request.getPathInfo());
        response.sendError(404);
    }

    private void gone(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.warn("gone: " + request.getPathInfo());
        response.sendError(410);
    }

    private void error(HttpServletRequest request, String method, Throwable throwable) {
        StringBuilder message = new StringBuilder();
        message.append(method).append(":").append(throwable.getMessage());
        if (request != null) {
            message.append('(');
            message.append("referer=").append(Servlet.referer(request));
            message.append(",pathinfo=").append(Servlet.pathInfo(request));
        }
        LOG.error(message.toString(), throwable);
    }

    private static String pathInfo(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getPathInfo();
    }

    private static String referer(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeader("Referer");
    }

    public static String getVmStartup() {
        return VM_STARTUP_STR;
    }
}

