/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.oneandone.jasmin.model.Attributes;
import net.oneandone.sushi.metadata.annotation.Type;
import net.oneandone.sushi.util.Separator;

@Type
public final class Call {
    public static void call(Attributes attributes, String callStr, OutputStream out) {
        List call = Separator.SPACE.split((CharSequence)callStr);
        if (call.size() < 1) {
            throw new IllegalArgumentException("invalid call: " + call);
        }
        String target = (String)call.remove(0);
        int idx = target.lastIndexOf(46);
        if (idx == -1) {
            throw new IllegalArgumentException("invalid target: " + target);
        }
        Object attribute = attributes.get(target.substring(0, idx));
        if (attribute == null) {
            throw new IllegalArgumentException("attribute not found: " + target);
        }
        Method method = Call.lookup(attribute.getClass(), target.substring(idx + 1), Call.formals(call.size()));
        if (method == null) {
            throw new IllegalArgumentException("method not found: " + target);
        }
        try {
            method.invoke(attribute, Call.actuals(call, out));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("illegal access", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("method failed: " + e.getTargetException());
        }
    }

    private static Class<?>[] formals(int strings) {
        Class[] result = new Class[strings + 1];
        for (int i = 0; i < strings; ++i) {
            result[i] = String.class;
        }
        result[strings] = OutputStream.class;
        return result;
    }

    private static Object[] actuals(List<String> arguments, OutputStream out) {
        Object[] result = new Object[arguments.size() + 1];
        for (int i = 0; i < result.length - 1; ++i) {
            result[i] = arguments.get(i);
        }
        result[result.length - 1] = out;
        return result;
    }

    private static Method lookup(Class<?> clazz, String name, Class<?>[] signature) {
        try {
            return clazz.getDeclaredMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            if (Object.class.equals(clazz)) {
                return null;
            }
            return Call.lookup(clazz.getSuperclass(), name, signature);
        }
    }

    private Call() {
    }
}

