/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.oneandone.graph.CyclicDependency;
import net.oneandone.jasmin.main.Servlet;
import net.oneandone.jasmin.model.Content;
import net.oneandone.jasmin.model.ContentCache;
import net.oneandone.jasmin.model.HashCache;
import net.oneandone.jasmin.model.References;
import net.oneandone.jasmin.model.Repository;
import net.oneandone.jasmin.model.Request;
import net.oneandone.sushi.fs.GetLastModifiedException;
import net.oneandone.sushi.io.Buffer;
import net.oneandone.sushi.util.Strings;

public class Engine {
    public static final String ENCODING = "utf-8";
    public final Repository repository;
    private final Semaphore computeSemaphore;
    public final HashCache hashCache;
    public final ContentCache contentCache;
    private final HashMap<String, CountDownLatch> pending;
    public AtomicLong requestedBytes;
    private static final MessageDigest DIGEST;

    public Engine(Repository repository) {
        this(repository, 8, 1000000, 10000000);
    }

    public Engine(Repository repository, int maxComputeThreads, int hashSize, int contentSize) {
        this.repository = repository;
        this.computeSemaphore = new Semaphore(maxComputeThreads);
        this.hashCache = new HashCache(hashSize);
        this.contentCache = new ContentCache(contentSize);
        this.pending = new HashMap();
        this.requestedBytes = new AtomicLong();
    }

    public int load() {
        return this.pending.size();
    }

    public long requestedBytes() {
        return this.requestedBytes.get();
    }

    public long computedBytes() {
        return this.contentCache.addedBytes();
    }

    public long removedBytes() {
        return this.contentCache.removedBytes();
    }

    public int request(String path, HttpServletResponse response, boolean gzip) throws IOException {
        byte[] bytes;
        Content content;
        try {
            content = this.doRequest(path);
        }
        catch (IOException e) {
            Servlet.LOG.error("request failed: " + e.getMessage(), (Throwable)e);
            response.setStatus(500);
            response.setContentType("text/html");
            try (PrintWriter writer = response.getWriter();){
                ((Writer)writer).write("<html><body><h1>" + e.getMessage() + "</h1>");
                ((Writer)writer).write("<details><br/>");
                this.printException(e, writer);
                ((Writer)writer).write("</body></html>");
            }
            return -1;
        }
        if (gzip) {
            response.setHeader("Content-Encoding", "gzip");
            bytes = content.bytes;
        } else {
            bytes = Engine.unzip(content.bytes);
        }
        response.addHeader("Vary", "Accept-Encoding");
        response.setBufferSize(0);
        response.setContentType(content.mimeType);
        response.setCharacterEncoding(ENCODING);
        if (content.lastModified != -1L) {
            response.setDateHeader("Last-Modified", content.lastModified);
        }
        response.getOutputStream().write(bytes);
        return bytes.length;
    }

    private void printException(Throwable e, Writer writer) throws IOException {
        writer.write("type: " + e.getClass() + "<br/>\n");
        writer.write("message: " + e.getMessage() + "<br/>\n");
        for (StackTraceElement element : e.getStackTrace()) {
            writer.write("  " + element.toString() + "<br/>\n");
        }
        if (e.getCause() != null && e.getCause() != e) {
            writer.write("<br/>\n");
            writer.write("... cause by ... <br/>\n");
            writer.write("<br/>\n");
            this.printException(e.getCause(), writer);
        }
    }

    public String request(String path) throws IOException {
        Content content = this.doRequest(path);
        return new String(Engine.unzip(content.bytes), ENCODING);
    }

    public long getLastModified(String path) throws GetLastModifiedException {
        Content content;
        String hash = (String)this.hashCache.probe(path);
        if (hash != null && (content = (Content)this.contentCache.probe(hash)) != null) {
            return content.lastModified;
        }
        return -1L;
    }

    public void free() {
        this.hashCache.resize(0);
        this.contentCache.resize(0);
    }

    private Content doRequest(String path) throws IOException {
        Content result = this.doRequestNoStats(path);
        this.requestedBytes.addAndGet(result.bytes.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content doRequestNoStats(String path) throws IOException {
        CountDownLatch gate;
        while (true) {
            Content content;
            String hash;
            if ((hash = (String)this.hashCache.lookup(path)) != null && (content = (Content)this.contentCache.lookup(hash)) != null) {
                return content;
            }
            HashMap<String, CountDownLatch> hashMap = this.pending;
            synchronized (hashMap) {
                gate = this.pending.get(path);
                if (gate == null) {
                    gate = new CountDownLatch(1);
                    if (this.pending.put(path, gate) != null) {
                        throw new IllegalStateException(path);
                    }
                    break;
                }
                if (gate.getCount() != 1L) {
                    throw new IllegalStateException(path + " " + gate.getCount());
                }
            }
            try {
                gate.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.doCompute(path, gate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content doCompute(String path, CountDownLatch gate) throws IOException {
        try {
            this.computeSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        try {
            Content content = this.doComputeUnlimited(path, gate);
            return content;
        }
        finally {
            this.computeSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content doComputeUnlimited(String path, CountDownLatch gate) throws IOException {
        Content content;
        if (gate.getCount() != 1L) {
            throw new IllegalStateException(path + " " + gate.getCount());
        }
        long startContent = System.currentTimeMillis();
        try {
            References references;
            try {
                references = this.repository.resolve(Request.parse(path));
            }
            catch (CyclicDependency e) {
                throw new RuntimeException(e.toString(), e);
            }
            catch (IOException e) {
                throw new IOException(path + ": " + e.getMessage(), e);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try (GZIPOutputStream dest = new GZIPOutputStream(result);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)dest, ENCODING);){
                references.writeTo(writer);
            }
            byte[] bytes = result.toByteArray();
            long endContent = System.currentTimeMillis();
            String hash = Engine.hash(bytes);
            content = new Content(references.type.getMime(), references.getLastModified(), bytes);
            this.hashCache.add(path, hash, endContent, 0L);
            this.contentCache.add(hash, content, startContent, endContent - startContent);
        }
        finally {
            HashMap<String, CountDownLatch> hashMap = this.pending;
            synchronized (hashMap) {
                if (gate.getCount() != 1L) {
                    throw new IllegalStateException(path + " " + gate.getCount());
                }
                if (this.pending.remove(path) != gate) {
                    throw new IllegalStateException();
                }
                gate.countDown();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(byte[] bytes) {
        byte[] result;
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            result = DIGEST.digest(bytes);
        }
        return Strings.toHex((byte[])result);
    }

    private static byte[] unzip(byte[] bytes) {
        try {
            return new Buffer().readBytes((InputStream)new GZIPInputStream(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unexpected IOException from ByteArrayInputStream: " + e.getMessage(), e);
        }
    }

    static {
        try {
            DIGEST = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

