/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

public enum MimeType {
    JS("text/javascript"),
    CSS("text/css");

    private final String mime;
    private final String extension;

    public static MimeType lookup(String path) {
        for (MimeType type : MimeType.values()) {
            if (!type.isInstance(path)) continue;
            return type;
        }
        return null;
    }

    private MimeType(String mime) {
        this.mime = mime;
        this.extension = "." + this.name().toLowerCase();
    }

    public String getMime() {
        return this.mime;
    }

    public boolean isInstance(String path) {
        return path.endsWith(this.extension);
    }

    public String comment(String line) {
        switch (this) {
            case JS: {
                return "//### " + line + "\n";
            }
            case CSS: {
                return "/**** " + line + " */\n";
            }
        }
        throw new IllegalArgumentException(this.toString());
    }
}

