/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.util.ArrayList;
import java.util.List;
import net.oneandone.jasmin.model.File;
import net.oneandone.jasmin.model.MimeType;
import net.oneandone.jasmin.model.Request;
import net.oneandone.jasmin.model.Source;
import net.oneandone.sushi.metadata.annotation.Type;
import net.oneandone.sushi.util.Separator;

@Type
public class Module {
    public static final Separator SEP = Separator.on((char)'+');
    public static final char NOT = '!';
    private final String name;
    private final List<File> files;
    private final List<Module> dependencies;
    private final Source source;
    private static final String DELIM = ":";

    public Module(String name, Source source) {
        if (name.contains(SEP.getSeparator())) {
            throw new IllegalArgumentException(name);
        }
        if (name.indexOf(33) != -1) {
            throw new IllegalArgumentException(name);
        }
        this.name = name;
        this.files = new ArrayList<File>();
        this.dependencies = new ArrayList<Module>();
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public List<File> files() {
        return this.files;
    }

    public List<Module> dependencies() {
        return this.dependencies;
    }

    public List<File> resolve(Request request) {
        ArrayList<File> result = new ArrayList<File>();
        boolean variantSeen = false;
        for (File file : this.files) {
            if (!file.getType().equals((Object)request.type)) continue;
            String actual = file.getVariant();
            if (actual == null) {
                result.add(file);
                continue;
            }
            variantSeen = true;
        }
        if (variantSeen) {
            this.addVariant(request.type, this.getBest(request.type, request.variant), result);
        }
        return result;
    }

    private void addVariant(MimeType type, String variant, List<File> result) {
        for (File file : this.files) {
            if (!file.getType().equals((Object)type) || !variant.equals(file.getVariant())) continue;
            result.add(file);
        }
    }

    public String getBest(MimeType type, String variant) {
        String requested = variant + DELIM;
        String best = null;
        for (File file : this.files) {
            String actual;
            if (!file.getType().equals((Object)type) || !requested.startsWith((actual = file.getVariant()) + DELIM)) continue;
            if (best == null) {
                best = actual;
                continue;
            }
            if (actual.length() <= best.length()) continue;
            best = actual;
        }
        if (best == null) {
            return "lead";
        }
        return best;
    }

    public String toString() {
        return this.getName();
    }
}

