/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.sushi.util.Separator;

public final class Parser {
    private static final Separator NL = Separator.on((char)'\n').trim().skipEmpty();

    public static void parseComment(String str, List<String> depends, List<String> calls) throws IOException {
        String prefix = "/* jasmin";
        if (!str.startsWith("/* jasmin")) {
            throw new IOException("missing jasmin comment");
        }
        int idx = str.indexOf("*/");
        if (idx == -1) {
            throw new IOException("jasmin comment is not closed");
        }
        for (String[] line : Parser.parse(str.substring("/* jasmin".length(), idx))) {
            String key = line[0];
            String value = line[1];
            if ("depend".equals(key)) {
                depends.add(value);
                continue;
            }
            if ("call".equals(key)) {
                calls.add(value);
                continue;
            }
            throw new IOException("unknown key: " + key);
        }
    }

    public static List<String[]> parse(String str) throws IOException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String line : NL.split((CharSequence)str)) {
            int idx = line.indexOf(61);
            if (idx == -1) {
                throw new IOException("malformed jasmin comment: missing '=' in line '" + line + "'");
            }
            result.add(new String[]{line.substring(0, idx).trim(), line.substring(idx + 1).trim()});
        }
        return result;
    }

    private Parser() {
    }
}

