/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.oneandone.jasmin.main.Servlet;
import net.oneandone.jasmin.model.MimeType;
import net.oneandone.mork.mapping.ErrorHandler;
import net.oneandone.mork.mapping.ExceptionErrorHandler;
import net.oneandone.mork.mapping.Mapper;
import net.oneandone.mork.misc.GenericException;
import net.oneandone.ssass.scss.Output;
import net.oneandone.ssass.scss.Stylesheet;
import net.oneandone.sushi.fs.GetLastModifiedException;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.fs.http.HttpNode;
import net.oneandone.sushi.fs.zip.ZipNode;

public class References {
    public static final byte LF = 10;
    private static final Mapper SSASS = new Mapper("net.oneandone.ssass.Mapper");
    public final MimeType type;
    public final boolean overallMinimize;
    public final List<Boolean> minimizes;
    public final List<Boolean> declarationsOnly;
    public final List<Node> nodes;

    public static References create(MimeType type, boolean minimize, Node node) {
        References result = new References(type, minimize);
        result.add(minimize, false, node);
        return result;
    }

    public References(MimeType type, boolean overallMinimize) {
        this.type = type;
        this.overallMinimize = overallMinimize;
        this.minimizes = new ArrayList<Boolean>();
        this.declarationsOnly = new ArrayList<Boolean>();
        this.nodes = new ArrayList<Node>();
    }

    public void add(boolean minimize, boolean declrationOnly, Node node) {
        this.minimizes.add(minimize);
        this.declarationsOnly.add(declrationOnly);
        this.nodes.add(node);
    }

    public void writeTo(Writer writer) throws IOException {
        switch (this.type) {
            case CSS: {
                this.writeCssTo(writer);
                break;
            }
            case JS: {
                this.writeJsTo(writer);
                break;
            }
            default: {
                throw new IllegalStateException(this.type.toString());
            }
        }
    }

    private void writeJsTo(Writer writer) throws IOException {
        Compiler compiler = new Compiler((ErrorManager)new LoggerErrorManager());
        CompilerOptions options = new CompilerOptions();
        options.setOutputCharset("utf-8");
        ArrayList<SourceFile> sources = new ArrayList<SourceFile>();
        ArrayList externals = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.get(i);
            sources.add(SourceFile.fromCode((String)(References.location(node) + "_" + i), (String)References.readString(node)));
        }
        Result result = compiler.compile(externals, sources, options);
        if (!result.success) {
            if (result.errors.length < 1) {
                throw new IllegalStateException();
            }
            throw new IOException(result.errors[0].sourceName + ":" + result.errors[0].lineNumber + ":" + result.errors[0].description);
        }
        if (this.overallMinimize) {
            writer.write(compiler.toSource());
        } else {
            boolean first = true;
            for (SourceFile source : sources) {
                if (first) {
                    first = false;
                } else {
                    writer.write(10);
                }
                if (!this.overallMinimize) {
                    writer.write(this.type.comment(source.getName()));
                }
                writer.write(source.getCode());
            }
        }
    }

    private static String readString(Node node) throws IOException {
        try {
            return node.readString();
        }
        catch (IOException e) {
            if (node instanceof HttpNode) {
                try {
                    return node.readString();
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                    throw e;
                }
            }
            throw e;
        }
    }

    protected void writeCssTo(Writer writer) throws IOException {
        this.writeCssTo(writer, new Output(writer, this.overallMinimize));
    }

    protected void writeCssTo(Writer writer, Output output) throws IOException {
        if (output.getMuted()) {
            throw new IllegalArgumentException();
        }
        Mapper mapper = SSASS.newInstance();
        mapper.setErrorHandler((ErrorHandler)new ExceptionErrorHandler());
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object[] results;
            Node node = this.nodes.get(i);
            if (i > 0) {
                writer.write(10);
            }
            if (!this.overallMinimize) {
                writer.write(this.type.comment(References.location(node)));
            }
            if ((results = mapper.run(node)) == null) {
                throw new IOException(node.toString() + ": css/sass error");
            }
            output.setMuted(this.declarationsOnly.get(i).booleanValue());
            try {
                ((Stylesheet)results[0]).toCss(output);
            }
            catch (GenericException e) {
                throw new IOException(node.toString() + ": css generation failed: " + e.getMessage(), e);
            }
            if (output.getMuted() == this.declarationsOnly.get(i).booleanValue()) continue;
            throw new IllegalStateException();
        }
    }

    public String readString() throws IOException {
        StringWriter result = new StringWriter();
        this.writeTo(result);
        return result.toString();
    }

    public byte[] readBytes() throws IOException {
        return this.readString().getBytes("utf-8");
    }

    public long getLastModified() throws GetLastModifiedException {
        long result = Long.MIN_VALUE;
        for (Node node : this.nodes) {
            if (node instanceof HttpNode) continue;
            result = Math.max(result, node.getLastModified());
        }
        return result == Long.MIN_VALUE ? -1L : result;
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof References) {
            References references = (References)obj;
            return this.type == references.type && this.minimizes.equals(references.minimizes) && this.nodes.equals(references.nodes);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.nodes.size(); ++i) {
            builder.append(this.nodes.get(i).getUri());
            builder.append(this.minimizes.get(i) != false ? "(min) " : " ");
        }
        return builder.toString();
    }

    public static String location(Node node) {
        if (node instanceof ZipNode) {
            String name = ((ZipNode)node).getRoot().getZip().getName();
            int idx = name.lastIndexOf(47);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            return "zip:" + name + "/" + node.getPath();
        }
        if (node instanceof FileNode) {
            return "file:" + node.getRelative((Node)node.getWorld().getWorking());
        }
        if (node instanceof HttpNode) {
            return "http:" + node.getName() + ((HttpNode)node).getQuery();
        }
        return node.getName();
    }

    static {
        SSASS.load();
    }

    public class LoggerErrorManager
    extends BasicErrorManager {
        public void println(CheckLevel level, JSError error) {
            switch (level) {
                case ERROR: {
                    Servlet.LOG.debug("error: " + error.toString());
                    break;
                }
                case WARNING: {
                    Servlet.LOG.debug("warning: " + error.toString());
                }
            }
        }

        protected void printSummary() {
        }
    }
}

