/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.oneandone.graph.CyclicDependency;
import net.oneandone.graph.Graph;
import net.oneandone.jasmin.descriptor.Base;
import net.oneandone.jasmin.descriptor.Library;
import net.oneandone.jasmin.descriptor.Resource;
import net.oneandone.jasmin.model.Attributes;
import net.oneandone.jasmin.model.Call;
import net.oneandone.jasmin.model.File;
import net.oneandone.jasmin.model.MimeType;
import net.oneandone.jasmin.model.Module;
import net.oneandone.jasmin.model.Parser;
import net.oneandone.jasmin.model.References;
import net.oneandone.jasmin.model.Request;
import net.oneandone.jasmin.model.Resolver;
import net.oneandone.jasmin.model.Source;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.fs.filter.Filter;
import net.oneandone.sushi.fs.http.HttpNode;
import net.oneandone.sushi.fs.memory.MemoryNode;
import net.oneandone.sushi.fs.zip.ZipNode;
import net.oneandone.sushi.metadata.annotation.Type;
import net.oneandone.sushi.util.Strings;
import net.oneandone.sushi.util.Util;

@Type
public class Repository {
    public static final String PROJECT_PROPERTIES = "META-INF/pominfo.properties";
    public static final String MODULE_DESCRIPTOR = "META-INF/jasmin.xml";
    public static final String APPLICATION_DESCRIPTOR = "WEB-INF/jasmin.xml";
    private final Attributes attributes;
    private final List<Module> modules;
    private Map<Module, List<String>> notLinked;
    private List<Node> reloadFiles;

    public static Repository load(Resolver resolver) throws IOException {
        Repository repository = new Repository();
        repository.loadClasspath(resolver);
        repository.link();
        return repository;
    }

    public Repository() {
        this(new Attributes(){

            @Override
            public Object get(String name) {
                throw new IllegalArgumentException("no such attribute: " + name);
            }
        });
    }

    public Repository(Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        this.attributes = attributes;
        this.modules = new ArrayList<Module>();
        this.notLinked = new HashMap<Module, List<String>>();
        this.reloadFiles = new ArrayList<Node>();
    }

    public List<Module> modules() {
        return this.modules;
    }

    public Module lookup(String name) {
        for (Module module : this.modules) {
            if (!name.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    public Module get(String name) {
        Module module = this.lookup(name);
        if (module == null) {
            throw new IllegalArgumentException("no such module: " + name);
        }
        return module;
    }

    public void add(Module module) {
        String name = module.getName();
        if (this.lookup(name) != null) {
            throw new IllegalArgumentException("duplicate module: " + name);
        }
        this.modules.add(module);
    }

    public List<String> sequence(String ... names) throws CyclicDependency {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        for (String name : names) {
            moduleList.add(this.get(name));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : this.sequence(moduleList)) {
            result.add(module.getName());
        }
        return result;
    }

    public List<Module> sequence(List<Module> moduleList) throws CyclicDependency {
        Module right;
        int i;
        Graph graph = new Graph();
        for (i = 0; i < moduleList.size(); ++i) {
            right = moduleList.get(i);
            graph.addNode((Object)right);
            if (i <= 0) continue;
            Module left = moduleList.get(i - 1);
            graph.addEdge((Object)left, (Object)right);
        }
        ArrayList<Module> work = new ArrayList<Module>();
        work.addAll(moduleList);
        for (i = 0; i < work.size(); ++i) {
            right = (Module)work.get(i);
            for (Module l : right.dependencies()) {
                graph.addEdge((Object)l, (Object)right);
                if (work.contains(l)) continue;
                work.add(l);
            }
        }
        return graph.sort();
    }

    public References resolve(Request request) throws IOException, CyclicDependency {
        ArrayList<Module> includes = new ArrayList<Module>();
        List<Module> excludes = new ArrayList<Module>();
        for (String name : Module.SEP.split((CharSequence)request.modules)) {
            if (name.length() == 0) {
                throw new IllegalStateException();
            }
            if (name.charAt(0) == '!') {
                excludes.add(this.get(name.substring(1)));
                continue;
            }
            includes.add(this.get(name));
        }
        List<Module> moduleList = this.sequence(includes);
        excludes = this.sequence(excludes);
        References references = new References(request.type, request.minimize);
        for (Module module : moduleList) {
            boolean declarationOnly;
            if (excludes.contains(module)) {
                if (request.type == MimeType.JS) continue;
                declarationOnly = true;
            } else {
                declarationOnly = false;
            }
            for (File file : module.resolve(request)) {
                Node resolved = file.get(request.minimize);
                boolean minimize = request.minimize && file.getMinimized() == null;
                references.add(minimize, declarationOnly, resolved);
            }
        }
        return references;
    }

    public List<String> getVariants() {
        ArrayList<String> results = new ArrayList<String>();
        for (Module module : this.modules) {
            for (File file : module.files()) {
                String variant = file.getVariant();
                if (variant == null || results.contains(variant)) continue;
                results.add(variant);
            }
        }
        return results;
    }

    public void loadClasspath(Resolver resolver) throws IOException {
        Enumeration<URL> e = this.getClass().getClassLoader().getResources(MODULE_DESCRIPTOR);
        while (e.hasMoreElements()) {
            this.loadModule(resolver, e.nextElement());
        }
    }

    private void loadModule(Resolver resolver, URL url) throws IOException {
        FileNode classpathItem = resolver.getWorld().locateClasspathItem(url, "/META-INF/jasmin.xml");
        FileNode base = classpathItem.isFile() ? classpathItem.openZip() : classpathItem;
        Node descriptor = resolver.resolve((Node)base, MODULE_DESCRIPTOR);
        Node properties = resolver.resolve((Node)base, PROJECT_PROPERTIES);
        this.loadLibrary(resolver, (Node)base, descriptor, properties);
    }

    public void loadApplication(Resolver resolver, Node docroot, Node descriptor) throws IOException {
        Node properties = docroot.getParent().join(new String[]{"classes", PROJECT_PROPERTIES});
        if (!properties.isFile()) {
            properties = docroot.join(new String[]{"WEB-INF/classes", PROJECT_PROPERTIES});
        }
        this.loadLibrary(resolver, docroot, descriptor, properties);
    }

    public void loadLibrary(Resolver resolver, Node base, Node descriptor, Node properties) throws IOException {
        this.addReload(descriptor);
        Source source = Source.load(properties, base);
        Library library = (Library)Library.TYPE.loadXml(descriptor).get();
        this.autoFiles(resolver, library, source);
        for (net.oneandone.jasmin.descriptor.Module descriptorModule : library.modules()) {
            Module module = new Module(descriptorModule.getName(), source);
            this.notLinked.put(module, descriptorModule.dependencies());
            for (Resource resource : descriptorModule.resources()) {
                File file = resolver.resolve(source.classpathBase, resource);
                this.addReload(file);
                resolver.resolve(source.classpathBase, resource);
                module.files().add(file);
            }
            this.add(module);
        }
    }

    private void addReload(File file) {
        this.addReload(file.getNormal());
        this.addReload(file.get(true));
    }

    private void addReload(Node node) {
        if (node instanceof HttpNode) {
            return;
        }
        if (!(node instanceof FileNode)) {
            if (node instanceof ZipNode) {
                node = node.getWorld().file(((ZipNode)node).getRoot().getZip().getName());
            } else if (!(node instanceof MemoryNode)) {
                throw new IllegalStateException("unexpected node: " + node);
            }
        }
        if (!this.reloadFiles.contains(node)) {
            this.reloadFiles.add(node);
        }
    }

    private void autoFiles(Resolver life, Library library, Source source) throws IOException {
        this.autoFiles(life, source, MimeType.JS, library.jss());
        this.autoFiles(life, source, MimeType.CSS, library.csss());
    }

    private void autoFiles(Resolver resolver, Source source, MimeType type, List<String> includes) throws IOException {
        List<Ref> refs;
        Filter filter = new Filter();
        filter.include(includes);
        HashMap<String, ArrayList<Ref>> map = new HashMap<String, ArrayList<Ref>>();
        for (Node node : source.classpathBase.find(filter)) {
            Ref ref = Ref.create(node, source);
            refs = (ArrayList<Ref>)map.get(ref.module);
            if (refs == null) {
                refs = new ArrayList<Ref>();
                map.put(ref.module, (ArrayList<Ref>)refs);
            }
            refs.add(ref);
        }
        for (Map.Entry entry : map.entrySet()) {
            Module module = this.lookup((String)entry.getKey());
            if (module == null) {
                module = new Module((String)entry.getKey(), source);
                this.modules.add(module);
            } else if (module.getSource() != source) {
                throw new IllegalStateException();
            }
            refs = (List)entry.getValue();
            while (!refs.isEmpty()) {
                ArrayList<String> calls;
                Ref minimized;
                Ref normal = (Ref)refs.remove(0);
                Ref companion = Repository.removeCompanionOpt(refs, normal);
                if (companion == null) {
                    minimized = normal.minimized ? normal : null;
                } else if (normal.minimized) {
                    minimized = normal;
                    normal = companion;
                } else {
                    minimized = companion;
                }
                File file = resolver.resolve(source.classpathBase, new Resource(type, Base.CLASSPATH, normal.path, minimized != null ? minimized.path : null, normal.variant));
                try {
                    List<String> depends = this.notLinked.get(module);
                    if (depends == null) {
                        depends = new ArrayList<String>();
                        this.notLinked.put(module, depends);
                    }
                    calls = new ArrayList<String>();
                    Parser.parseComment(Repository.stripBom(file.getNormal().readString()), depends, calls);
                }
                catch (IOException e) {
                    throw new IOException(normal.node.getUri() + ": " + e.getMessage(), e);
                }
                if (calls.size() > 0) {
                    if (file.getMinimized() != null) {
                        throw new UnsupportedOperationException(file.getNormal().getUri().toString());
                    }
                    MemoryNode tmp = resolver.getWorld().memoryNode(new byte[0]);
                    try (OutputStream dest = tmp.newOutputStream();){
                        for (String webservice : calls) {
                            Call.call(this.attributes, webservice, dest);
                            dest.write(10);
                        }
                        try (InputStream orig = file.getNormal().newInputStream();){
                            resolver.getWorld().getBuffer().copy(orig, dest);
                        }
                    }
                    file = new File((Node)tmp, null, file.getType(), file.getVariant());
                }
                module.files().add(file);
                this.addReload(file);
            }
        }
    }

    private static String stripBom(String str) {
        if (!str.isEmpty() && str.charAt(0) == '\ufeff') {
            return str.substring(1);
        }
        return str;
    }

    private static Ref removeCompanionOpt(List<Ref> refs, Ref cmp) {
        Iterator<Ref> iter = refs.iterator();
        while (iter.hasNext()) {
            Ref ref = iter.next();
            if (!ref.module.equals(cmp.module) || !Util.eq((Object)ref.variant, (Object)cmp.variant)) continue;
            iter.remove();
            return ref;
        }
        return null;
    }

    public List<Node> link() {
        StringBuilder problems = new StringBuilder();
        for (Map.Entry<Module, List<String>> entry : this.notLinked.entrySet()) {
            Module module = entry.getKey();
            List<Module> dependencies = module.dependencies();
            for (String name : entry.getValue()) {
                Module resolved = this.lookup(name);
                if (resolved == null) {
                    problems.append("module '" + module.getName() + "': cannot resolve dependency '" + name + "'\n");
                    continue;
                }
                dependencies.add(resolved);
            }
        }
        if (problems.length() > 0) {
            throw new IllegalArgumentException(problems.toString());
        }
        List<Node> result = this.reloadFiles;
        this.notLinked = null;
        this.reloadFiles = null;
        return result;
    }

    private static class Ref {
        private static final String MIN = "-min";
        public final Node node;
        public final String path;
        public final String module;
        public final String variant;
        public final boolean minimized;

        public static Ref create(Node node, Source source) {
            String variant;
            boolean minimized;
            String path;
            String module = path = node.getRelative(source.classpathBase);
            module = Strings.removeLeftOpt((String)module, (String)"PUSTEFIX-INF/");
            module = Strings.removeLeftOpt((String)module, (String)"pustefix/");
            module = Strings.removeLeftOpt((String)module, (String)"htdocs/");
            module = Strings.removeLeftOpt((String)module, (String)"script/");
            int idx = (module = Strings.removeLeftOpt((String)module, (String)"style/")).lastIndexOf(46);
            if (idx != -1) {
                module = module.substring(0, idx);
            }
            if (minimized = module.endsWith(MIN)) {
                module = module.substring(0, module.length() - MIN.length());
            }
            if ((idx = module.indexOf(58)) != -1) {
                variant = module.substring(idx + 1);
                module = module.substring(0, idx);
            } else {
                variant = null;
            }
            module = source.artifactId + "-" + module.replace('/', '-');
            return new Ref(node, path, module, variant, minimized);
        }

        Ref(Node node, String path, String module, String variant, boolean minimized) {
            this.node = node;
            this.path = path;
            this.module = module;
            this.variant = variant;
            this.minimized = minimized;
        }
    }
}

