/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import net.oneandone.jasmin.main.Servlet;
import net.oneandone.jasmin.model.MimeType;

public class Request {
    public final String modules;
    public final boolean minimize;
    public final MimeType type;
    public final String variant;

    public static Request parse(String path) {
        Request result;
        String variant;
        String second;
        int firstIdx = path.indexOf(47);
        if (firstIdx == -1) {
            throw new IllegalArgumentException("missing slash: '" + path + "'");
        }
        String first = path.substring(0, firstIdx);
        int secondIdx = path.indexOf(47, firstIdx + 1);
        if (secondIdx == -1) {
            second = path.substring(firstIdx + 1);
            variant = "lead";
        } else {
            second = path.substring(firstIdx + 1, secondIdx);
            variant = path.substring(secondIdx + 1);
            if (variant.length() == 0) {
                throw new IllegalArgumentException("empty variant: " + path);
            }
        }
        try {
            result = Request.create(first, second, variant);
        }
        catch (IllegalArgumentException e) {
            try {
                result = Request.create(second, first, variant);
                Servlet.LOG.warn("deprecated request: type should preceed modules: " + path);
            }
            catch (IllegalArgumentException eAgain) {
                throw e;
            }
        }
        return result;
    }

    public static Request create(String typeName, String modules, String variant) {
        boolean minimize = (typeName = typeName.toUpperCase()).endsWith("-MIN");
        if (minimize) {
            typeName = typeName.substring(0, typeName.length() - 4);
        }
        return new Request(modules, MimeType.valueOf(typeName), minimize, variant);
    }

    public Request(String modules, MimeType type, boolean minimize, String variant) {
        this.modules = modules;
        this.type = type;
        this.minimize = minimize;
        this.variant = variant;
    }

    public int hashCode() {
        return this.modules.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.modules);
        builder.append('/');
        builder.append(this.variant);
        builder.append(this.type.toString().toLowerCase());
        if (this.minimize) {
            builder.append("-min");
        }
        return builder.toString();
    }
}

