/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.oneandone.jasmin.descriptor.Base;
import net.oneandone.jasmin.descriptor.Resource;
import net.oneandone.jasmin.model.File;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.fs.http.HttpNode;
import net.oneandone.sushi.fs.http.HttpRoot;
import net.oneandone.sushi.fs.zip.ZipNode;
import org.pustefixframework.live.LiveResolver;

public class Resolver {
    private World world;
    private final LiveResolver live;
    private final Map<Base, Node> bases;

    public Resolver(World world) {
        this(world, false);
    }

    public Resolver(World world, boolean live) {
        this.world = world;
        this.live = live ? new LiveResolver() : null;
        this.bases = new HashMap<Base, Node>();
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isLife() {
        return this.live != null;
    }

    public FileNode getLiveXml() {
        java.io.File file = this.live.getLiveXmlFile();
        return file != null ? this.world.file(file) : null;
    }

    public Node get(Base base) {
        return this.bases.get((Object)base);
    }

    public void add(Base base, Node node) {
        if (this.bases.put(base, node) != null) {
            throw new IllegalArgumentException("already mapped: " + (Object)((Object)base));
        }
    }

    public void reset() {
        this.bases.clear();
    }

    public File resolve(Node classpathBase, Resource resource) throws IOException {
        Base base = resource.getBase();
        Node baseResolved = base == Base.CLASSPATH ? classpathBase : this.bases.get((Object)base);
        if (baseResolved == null) {
            throw new IllegalStateException("unknown base: " + base.toString());
        }
        Node normal = this.resolve(baseResolved, resource.getPath());
        String minimizedPath = resource.getMinPath();
        Node minimized = minimizedPath == null ? null : this.resolve(baseResolved, minimizedPath);
        return new File(normal, minimized, resource.getType(), resource.getVariant());
    }

    public Node resolve(Node root, String path) throws IOException {
        try {
            return this.doResolve(root, path);
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("LifeResolver failed", e);
        }
    }

    private Node doResolve(Node root, String path) throws Exception {
        FileNode resolvedRoot;
        Node result;
        java.io.File file;
        if (path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if (root instanceof HttpNode) {
            String queryPart;
            String pathPart;
            HttpRoot webdavRoot = ((HttpNode)root).getRoot();
            int idx = path.indexOf(63);
            if (idx == -1) {
                pathPart = path;
                queryPart = null;
            } else {
                pathPart = path.substring(0, idx);
                queryPart = path.substring(idx + 1);
            }
            if (!root.getPath().isEmpty()) {
                pathPart = webdavRoot.getFilesystem().join(new String[]{root.getPath(), pathPart});
            }
            return webdavRoot.node(pathPart, queryPart);
        }
        if (this.live != null && (file = root instanceof FileNode ? this.live.resolveLiveRoot(((FileNode)root).getAbsolute(), "/" + path) : (root instanceof ZipNode ? this.live.resolveLiveRoot(((ZipNode)root).getRoot().getZip().getName(), "/" + path) : null)) != null && (result = (resolvedRoot = this.world.file(file)).join(new String[]{path})).exists()) {
            return result;
        }
        return root.join(new String[]{path});
    }
}

