/*
 * Decompiled with CFR 0.152.
 */
package net.oneandone.jasmin.model;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.NodeReader;

public class Source {
    public final Node<?> classpathBase;
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final String scm;

    public static Source load(Node properties, Node base) throws IOException {
        Properties p;
        properties.checkExists();
        try (NodeReader src = properties.newReader();){
            p = new Properties();
            p.load((Reader)src);
        }
        String groupId = Source.get(p, "groupId");
        String artifactId = Source.get(p, "artifactId");
        String version = Source.get(p, "version");
        String scm = Source.get(p, "scmConnection");
        return new Source(base, groupId, artifactId, version, scm);
    }

    private static String get(Properties p, String key) {
        String value = p.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("unknown key: " + key);
        }
        return value;
    }

    public Source(Node<?> classpathBase, String groupId, String artifactId, String version, String scm) {
        this.classpathBase = classpathBase;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scm = scm;
    }
}

