/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import com.mockrunner.mock.jms.MockTopicPublisher;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import jakarta.jms.JMSException;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopicTransmissionManager
implements Serializable {
    private MockConnection connection;
    private MockSession session;
    private List topicPublisherList;
    private List topicSubscriberList;
    private Map topicDurableSubscriberMap;

    public TopicTransmissionManager(MockConnection connection, MockSession session) {
        this.connection = connection;
        this.session = session;
        this.topicPublisherList = new ArrayList();
        this.topicSubscriberList = new ArrayList();
        this.topicDurableSubscriberMap = new HashMap();
    }

    public void closeAll() {
        this.closeAllTopicPublishers();
        this.closeAllTopicSubscribers();
        this.closeAllTopicDurableSubscribers();
    }

    public void closeAllTopicPublishers() {
        for (Object aTopicPublisherList : this.topicPublisherList) {
            TopicPublisher publisher = (TopicPublisher)aTopicPublisherList;
            try {
                publisher.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public void closeAllTopicSubscribers() {
        for (Object aTopicSubscriberList : this.topicSubscriberList) {
            TopicSubscriber subscriber = (TopicSubscriber)aTopicSubscriberList;
            try {
                subscriber.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public void closeAllTopicDurableSubscribers() {
        for (Object o : this.topicDurableSubscriberMap.keySet()) {
            TopicSubscriber subscriber = (TopicSubscriber)this.topicDurableSubscriberMap.get(o);
            try {
                subscriber.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public MockTopicPublisher createTopicPublisher(MockTopic topic) {
        MockTopicPublisher publisher = new MockTopicPublisher(this.connection, this.session, topic);
        this.topicPublisherList.add(publisher);
        return publisher;
    }

    public MockTopicPublisher getTopicPublisher(int index) {
        if (this.topicPublisherList.size() <= index || index < 0) {
            return null;
        }
        return (MockTopicPublisher)this.topicPublisherList.get(index);
    }

    public MockTopicPublisher getTopicPublisher(String topicName) {
        List publishers = this.getTopicPublisherList(topicName);
        if (publishers.size() <= 0) {
            return null;
        }
        return (MockTopicPublisher)publishers.get(0);
    }

    public List getTopicPublisherList(String topicName) {
        ArrayList<TopicPublisher> resultList = new ArrayList<TopicPublisher>();
        for (Object aTopicPublisherList : this.topicPublisherList) {
            TopicPublisher publisher = (TopicPublisher)aTopicPublisherList;
            try {
                if (!publisher.getTopic().getTopicName().equals(topicName)) continue;
                resultList.add(publisher);
            }
            catch (JMSException jMSException) {}
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getTopicPublisherList() {
        return Collections.unmodifiableList(this.topicPublisherList);
    }

    public MockTopicSubscriber createTopicSubscriber(MockTopic topic, String messageSelector, boolean noLocal) {
        MockTopicSubscriber subscriber = new MockTopicSubscriber(this.connection, this.session, topic, messageSelector, noLocal);
        subscriber.setDurable(false);
        this.topicSubscriberList.add(subscriber);
        return subscriber;
    }

    public MockTopicSubscriber getTopicSubscriber(int index) {
        if (this.topicSubscriberList.size() <= index || index < 0) {
            return null;
        }
        return (MockTopicSubscriber)this.topicSubscriberList.get(index);
    }

    public MockTopicSubscriber getTopicSubscriber(String topicName) {
        List subscribers = this.getTopicSubscriberList(topicName);
        if (subscribers.size() <= 0) {
            return null;
        }
        return (MockTopicSubscriber)subscribers.get(0);
    }

    public List getTopicSubscriberList(String topicName) {
        ArrayList<TopicSubscriber> resultList = new ArrayList<TopicSubscriber>();
        for (Object aTopicSubscriberList : this.topicSubscriberList) {
            TopicSubscriber subscriber = (TopicSubscriber)aTopicSubscriberList;
            try {
                if (!subscriber.getTopic().getTopicName().equals(topicName)) continue;
                resultList.add(subscriber);
            }
            catch (JMSException jMSException) {}
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getTopicSubscriberList() {
        return Collections.unmodifiableList(this.topicSubscriberList);
    }

    public MockTopicSubscriber createDurableTopicSubscriber(MockTopic topic, String name, String messageSelector, boolean noLocal) {
        MockTopicSubscriber subscriber = new MockTopicSubscriber(this.connection, this.session, topic, messageSelector, noLocal);
        subscriber.setDurable(true);
        subscriber.setName(name);
        this.topicDurableSubscriberMap.put(name, subscriber);
        return subscriber;
    }

    public MockTopicSubscriber getDurableTopicSubscriber(String name) {
        return (MockTopicSubscriber)this.topicDurableSubscriberMap.get(name);
    }

    public void removeTopicDurableSubscriber(String name) {
        this.topicDurableSubscriberMap.remove(name);
    }

    public Map getDurableTopicSubscriberMap(String topicName) {
        HashMap resultMap = new HashMap();
        for (Object nextName : this.topicDurableSubscriberMap.keySet()) {
            MockTopicSubscriber subscriber = (MockTopicSubscriber)this.topicDurableSubscriberMap.get(nextName);
            try {
                if (null == subscriber || !subscriber.getTopic().getTopicName().equals(topicName)) continue;
                resultMap.put(nextName, subscriber);
            }
            catch (JMSException jMSException) {}
        }
        return resultMap;
    }

    public Map getDurableTopicSubscriberMap() {
        return Collections.unmodifiableMap(this.topicDurableSubscriberMap);
    }
}

