/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockServerSessionPool;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;

public class MockConnectionConsumer
implements ConnectionConsumer {
    private MockConnection connection;
    private ServerSessionPool sessionPool;
    private boolean closed;

    public MockConnectionConsumer(MockConnection connection, ServerSessionPool serverSessionPool) {
        this.connection = connection;
        this.closed = false;
        this.sessionPool = serverSessionPool;
        if (null == this.sessionPool) {
            this.sessionPool = new MockServerSessionPool(connection);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setServerSessionPool(ServerSessionPool serverSessionPool) {
        this.sessionPool = serverSessionPool;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        this.connection.throwJMSException();
        return this.sessionPool;
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }
}

