/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueueConnection;
import com.mockrunner.mock.jms.MockTopicConnection;
import com.mockrunner.mock.jms.jms2_compat.Callback;
import com.mockrunner.mock.jms.jms2_compat.Jms2Context;
import com.mockrunner.mock.jms.jms2_compat.Jms2Util;
import jakarta.jms.Connection;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MockConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory,
Serializable {
    private DestinationManager destinationManager;
    private ConfigurationManager configurationManager;
    private CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    private JMSException exception;

    public MockConnectionFactory(DestinationManager destinationManager, ConfigurationManager configurationManager) {
        this.destinationManager = destinationManager;
        this.configurationManager = configurationManager;
        this.exception = null;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String name, String password) throws JMSException {
        MockConnection connection = new MockConnection(this.destinationManager, this.configurationManager, name, password);
        connection.setJMSException(this.exception);
        this.connections.add(connection);
        return connection;
    }

    public JMSContext createContext() {
        return Jms2Util.execute(new Callback<JMSContext>(){

            @Override
            public JMSContext execute() throws JMSException {
                Connection connection = MockConnectionFactory.this.createConnection();
                Session session = connection.createSession(false, 1);
                return new Jms2Context(connection, session);
            }
        });
    }

    public JMSContext createContext(final String arg0, final String arg1) {
        return Jms2Util.execute(new Callback<Jms2Context>(){

            @Override
            public Jms2Context execute() throws JMSException {
                Connection connection = MockConnectionFactory.this.createConnection(arg0, arg1);
                Session session = connection.createSession(false, 1);
                return new Jms2Context(connection, session);
            }
        });
    }

    public JMSContext createContext(final String arg0, final String arg1, final int arg2) {
        return Jms2Util.execute(new Callback<Jms2Context>(){

            @Override
            public Jms2Context execute() throws JMSException {
                Connection connection = MockConnectionFactory.this.createConnection(arg0, arg1);
                Session session = connection.createSession(arg2 == 0, arg2);
                return new Jms2Context(connection, session);
            }
        });
    }

    public JMSContext createContext(final int sessionMode) {
        return Jms2Util.execute(new Callback<Jms2Context>(){

            @Override
            public Jms2Context execute() throws JMSException {
                Connection connection = MockConnectionFactory.this.createConnection();
                Session session = connection.createSession(0 == sessionMode, sessionMode);
                return new Jms2Context(connection, session);
            }
        });
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String name, String password) throws JMSException {
        MockQueueConnection connection = new MockQueueConnection(this.destinationManager(), this.configurationManager(), name, password);
        connection.setJMSException(this.exception());
        this.connections().add(connection);
        return connection;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String name, String password) throws JMSException {
        MockTopicConnection connection = new MockTopicConnection(this.destinationManager(), this.configurationManager(), name, password);
        connection.setJMSException(this.exception());
        this.connections().add(connection);
        return connection;
    }

    public void setJMSException(JMSException exception) {
        this.exception = exception;
    }

    public void clearConnections() {
        this.connections.clear();
    }

    public MockConnection getConnection(int index) {
        if (this.connections.size() <= index) {
            return null;
        }
        return (MockConnection)this.connections.get(index);
    }

    public MockConnection getLatestConnection() {
        if (this.connections.size() == 0) {
            return null;
        }
        return (MockConnection)this.connections.get(this.connections.size() - 1);
    }

    protected DestinationManager destinationManager() {
        return this.destinationManager;
    }

    protected ConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    protected List connections() {
        return this.connections;
    }

    protected JMSException exception() {
        return this.exception;
    }
}

