/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockSession;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.activemq.filter.mockrunner.Filter;

public abstract class MockDestination
implements Destination,
Serializable {
    private Set sessions = new CopyOnWriteArraySet();
    private List currentMessages = new CopyOnWriteArrayList();
    private List receivedMessages = new CopyOnWriteArrayList();

    public abstract void addMessage(Message var1) throws JMSException;

    public void loadMessage(Message message) {
        this.addCurrentMessage(message);
    }

    public boolean isEmpty() {
        return this.currentMessages.size() <= 0;
    }

    public void clear() {
        this.currentMessages.clear();
    }

    public void reset() {
        this.currentMessages.clear();
        this.receivedMessages.clear();
    }

    public Message getMessage() {
        if (this.currentMessages.size() <= 0) {
            return null;
        }
        return (Message)this.currentMessages.remove(0);
    }

    public Message getMatchingMessage(Filter filter) {
        for (int ii = 0; ii < this.currentMessages.size(); ++ii) {
            Message currentMessage = (Message)this.currentMessages.get(ii);
            try {
                if (!filter.matches(currentMessage)) continue;
                this.currentMessages.remove(ii);
                return currentMessage;
            }
            catch (JMSException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    public List getCurrentMessageList() {
        return Collections.unmodifiableList(this.currentMessages);
    }

    public List getReceivedMessageList() {
        return Collections.unmodifiableList(this.receivedMessages);
    }

    public void addSession(Session session) {
        this.sessions.add(session);
    }

    public void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public Set sessionSet() {
        return Collections.unmodifiableSet(this.sessions);
    }

    protected void addReceivedMessage(Message message) {
        this.receivedMessages.add(message);
    }

    protected void addCurrentMessage(Message message) {
        this.currentMessages.add(message);
    }

    protected void acknowledgeMessage(Message message, MockSession session) throws JMSException {
        if (session.isAutoAcknowledge()) {
            message.acknowledge();
        }
    }
}

